// compwave.h -- definition for ComplexWaveform class
//
// (c) 1996 Mark Huckvale University College London

// The ComplexWaveform class provides a basic set of functions for
// manipulating complex-valued signals for DSP

#ifndef __CompWave_H
#define __CompWave_H

#include "wavecomp.h"

class ComplexWaveform : public WaveComplex {
public:
	// constructors + assignment
	ComplexWaveform(int size=1,double srate=20000) : WaveComplex(size,srate,1) {};
	ComplexWaveform(const WaveComplex& isig) : WaveComplex(isig) {};
	ComplexWaveform& operator=(const WaveComplex& isig)
	{
		WaveComplex::operator=(isig);
		return *this;
	}
	// specialised functions
	void plot(Graph& gr,int gno,const char *pt,const char *xt,const char *yt) const
	{
		WaveComplex::realplot(gr,gno,(pt)?pt:"Waveform",
			(xt)?xt:"Time (s)",(yt)?yt:"Real");
	};
	void plotMag(Graph& gr,int gno=1,const char *pt=0,const char *xt=0,const char *yt=0) const
	{
		WaveComplex::magplot(gr,gno,(pt)?pt:"Waveform",
			(xt)?xt:"Time (s)",(yt)?yt:"Mag");
	}
	void plotLogMag(Graph& gr,int gno=1,const char *pt=0,const char *xt=0,const char *yt=0) const
	{
		WaveComplex::dbplot(gr,gno,(pt)?pt:"Waveform",
			(xt)?xt:"Time (s)",(yt)?yt:"Mag (dB)");
	}
	void plotPhase(Graph& gr,int gno=1,const char *pt=0,const char *xt=0,const char *yt=0) const
	{
		WaveComplex::argplot(gr,gno,(pt)?pt:"Waveform",
			(xt)?xt:"Time (s)",(yt)?yt:"Phase (rad)");
	}
	void plotReal(Graph& gr,int gno=1,const char *pt=0,const char *xt=0,const char *yt=0) const
	{
		WaveComplex::realplot(gr,gno,(pt)?pt:"Waveform",
			(xt)?xt:"Time (s)",(yt)?yt:"Real");
	}
	void plotImag(Graph& gr,int gno=1,const char *pt=0,const char *xt=0,const char *yt=0) const
	{
		WaveComplex::imagplot(gr,gno,(pt)?pt:"Waveform",
			(xt)?xt:"Time (s)",(yt)?yt:"Imag");
	}
};
#endif
