// graph.h -- definition for graphics manager class
//
// (c) 1996 Mark Huckvale University College London

#ifndef _GRAPH_H_
#define _GRAPH_H_

#if 0
#include <stdio.h>
#include "SFSCONFG.h"
#include "sfs.h"
#include "dig.h"
#endif

#include "dgraph.h"

// The class Graph provides control over a virtual graphics display
// upon which simple x-y graphs may be displayed.

class Graph {
public:
	enum state_enum {
		noinit,		// not initialised
		clean,		// initialised + clear
		dirty		// initialised + drawing
	};
private:
	int	device;		// output device (GTERM or GPRINT)
	enum state_enum state;	// state flags
	int	nhoriz;		// # graphs horizontally
	int	nvert;		// # graphs vertically
	int	xmode;		// x-axis mode
	int	ymode;		// y-axis mode
	int	gtype;		// graph type
	int	dobox;		// enclosing box
	char	*plotchar;	// character to plot
	char	*stitle;	// screen title
	char	*gtitle;	// graph title
	char	*xtitle;	// x-axis label
	char	*ytitle;	// y-axis label
	double	*xdata;		// x-axis data
	int	*gused;		// record of # times used
public:
	// access functions
	int	numhoriz() const { return nhoriz; };
	int	numvert() const { return nvert; };
	enum state_enum getstate() const { return state; };
	// constructor
	Graph(int nrow=1,int ncol=1,const char *title=0,int dev=0);
	~Graph();
	// set values
	void 	setsize(int nrow=1,int ncol=1);
	void	settitle(const char *title);
	void	settype(int type);
	void	setchar(char ch);
	void	setbox(int flag);
	void	setxzero(int flag);
	void	setyzero(int flag);
	void	setxaxis(int pos);
	void	setyaxis(int pos);
	void	setxlabel(int pos);
	void	setylabel(int pos);
	void	setxscale(int flag);
	void	setyscale(int flag);
	void	setxlog(int flag);
	void	setylog(int flag);
	void	setequal(int flag);
	void	setgtitle(const char *title);
	void	setxtitle(const char *title);
	void	setytitle(const char *title);
	void	setxdata(int flag,double *xarray);
	// force open/clear/close/wait-for-key
	void	open(int dev=-1);
	void	openraw(int dev=-1);
	void	clear();
	void	close();
	void	wait();
	// basic graph display
	void	plot(double *ydata,int ylen,int gno=1);
	void	axes(double xmin,double xmax,double ymin,double ymax,int gno=1);
};

// defines for flags
#define GRAPH_OFF	0
#define GRAPH_ON	1
#define GRAPH_BOTTOM	DGlowax
#define GRAPH_LEFT	DGlowax
#define GRAPH_TOP	DGhighax
#define GRAPH_RIGHT	DGhighax
#define GRAPH_POINT	DGpoints
#define GRAPH_LINE	DGline
#define GRAPH_HIST	DGhist
#define GRAPH_HISTEND	DGhistend
#define GRAPH_HISTDIV	DGhistdiv
#define GRAPH_BAR	DGbar
#define GRAPH_X_ALL	0
#define GRAPH_X_FIRST	DGfirst
#define GRAPH_X_LAST	DGlast
#define GRAPH_X_NEXT	DGnext
#define GRAPH_X_INC	DGinc
#define GRAPH_X_MULT	DGmult

#endif
