// quantise.cpp -- Linear Quantisation (Real <-> Integer)
//
//	QuantiseSample()	linear quantisation
//	Quantise()		linear quantisation of waveform
//	MakeCont()		make quantised signal continous
//
// C++ (c) 1996 Mark Huckvale University College London

#include "tools.h"
#include "quantise.h"

int	QuantiseSample(
	double value,		// input value
	double quanta		// quantisation step
	)			// returns quantised sample
{
	// truncate towards 0
	return (int)(value/quanta);
}

Signal	Quantise(
	const Waveform& iwv,	// real-valued waveform
	double quanta		// quantisation step
	)			// returns quantised signal
{
	Signal owv(iwv.count(),iwv.rate());
	for (int i=0;i<owv.count();i++)
		owv[i] = QuantiseSample(iwv[i+1],quanta);
	return owv;
}

Waveform MakeCont(
	const Signal& iwv,	// quantised signal
	double quanta		// quantisation step
	)			// returns real-valued signal
{
	Waveform owv(iwv.count(),iwv.rate());
	for (int i=1;i<=owv.count();i++)
		owv[i] = iwv[i-1] * quanta;
	return owv;
}

