// reson.cpp -- implementation of simple digital resonator
//
// C++ (c) 1996 Mark Huckvale University College London

#include "tools.h"
#include "ltisys.h"
#include "reson.h"

// The Resonator function sets up a linear system consisting
// of a complex pole pair

LTISystem Resonator(
	double	freq,	// natural frequency
			// (fraction of sample rate)
	double	bwid	// bandwidth
			// (fraction of sampling rate)
	)		// returns linear system
{
	LTISystem ltis(0,2);

	// get parameters as angles
	double wf = 2*PI*freq;
	double wb = 2*PI*bwid;

	// estimate pole radius from bandwidth
	//   (rule of thumb)
	double r = 1.0 - wb/2;

	// set up numerator
	ltis.a[0] = 1.0;

	// set up denominator: quadratic formula
	ltis.b[1] = -2.0 * r * cos(wf);
	ltis.b[2] = r * r;

	// adjust numerator for unity gain at DC
	ltis.a[0] /= mag(ltis.response(0));

	return ltis;
}
