// sampsine.cpp -- Sampling of Sinusoids
//
//	SampleSine()	retrieve samples from sine wave
//
// C++ (c) 1996 Mark Huckvale University College London

#include "tools.h"
#include "sampsine.h"

double SampleSine(
	double freq,	// sine frequency (Hz)
	double amp,	// sine peak amplitude
	double phase,	// sine phase (degrees)
	double time	// sample time =
			//   sample # * sample period
	)		// returns sample value
{
	// angular frequency (radians/sec)
	double	rfreq = 2.0 * PI * freq;
	// phase in radians
	double	rphase = 2.0 * PI * phase / 360.0;
	// sample sine function
	return amp * sin(rfreq * time - rphase);
}
