// wave.h -- definition for dynamic waveform abstract class
//
// (c) 1996 Mark Huckvale University College London

// The abstract class Wave underlies support for the storage,
// manipulation, display, and replay of a range of vectors.

#ifndef _WAVE_H
#define _WAVE_H

#if 0
#include "graph.h"
#endif
class Graph;

class Wave {
protected:
	int	alloc;		// allocated size
	int	siz;		// # samples
	int	lobound;	// low bound to array
	double	tau;		// sampling period
public:
	// access functions
	int	allocsize() const { return alloc; };
	int	count() const { return siz; };
	int	first() const { return lobound; };
	double	period() const { return tau; };
	double	rate() const { return 1.0/tau; };
	// constructors
	Wave() {};
	virtual ~Wave() {};
	// pure virtual functions
	virtual void dump(int len=-1,int first=0) const = 0;
	virtual void plot(Graph& gr,int gno=1,const char *title=0,const char *xt=0,const char *yt=0) const = 0;
};

// allocation parameters
#define WAVE_ALLOC_CHUNK	1024

// forward reference to classes to be declared
class WaveShort;		// short integer waveform
class WaveDouble;		// double floating-point waveform
class WaveComplex;		// complex waveform

#endif
