// WaveComplex.h -- definition for dynamic Complex waveform class
//
// (c) 1996 Mark Huckvale University College London

// The class WaveComplex supports the storage, manipulation, display,
// and replay of double-precision Complex waveforms.

#ifndef _WaveComplex_H
#define _WaveComplex_H

#include "wave.h"
#include "complex.h"

class WaveComplex : public Wave {
protected:
	Complex	*buf;		// waveform buffer
public:
	// constructors
	WaveComplex(int length=1,double rate=20000.0,int first=0);
	WaveComplex(const WaveComplex& wv);	// Copy constructor
	~WaveComplex();
	// virtual functions
	void dump(int len=-1,int first=0) const;
	void plot(Graph& gr,int gno,const char *title,const char *xt,const char *yt) const;
	// plotting functions
	void realplot(Graph& gr,int gno,const char *title,const char *xt,const char *yt) const;
	void imagplot(Graph& gr,int gno,const char *title,const char *xt,const char *yt) const;
	void magplot(Graph& gr,int gno,const char *title,const char *xt,const char *yt) const;
	void argplot(Graph& gr,int gno,const char *title,const char *xt,const char *yt) const;
	void dbplot(Graph& gr,int gno,const char *title,const char *xt,const char *yt) const;
	// assignment operator
	WaveComplex& operator= (const WaveComplex& wv);
	// sample access
	Complex& operator[] (const int idx);
	const Complex& operator[] (const int idx) const;
	// concatenation
	WaveComplex& operator+= (const Complex val);
	WaveComplex& operator+= (const WaveComplex& wv);
	WaveComplex operator+ (const WaveComplex& wv);
	// cut function
	WaveComplex cut(int first,int len) const;
	// conversion functions
	WaveDouble realtoWaveDouble() const;
	WaveDouble imagtoWaveDouble() const;
	WaveDouble magtoWaveDouble() const;
	WaveDouble argtoWaveDouble() const;
};
#endif
