// signal.h -- definition for signal (short-integer waveform) class
//
// (c) 1996 Mark Huckvale University College London

// The Signal class provides a basic set of functions for
// manipulating signals in their entirety

#ifndef __Signal_H
#define __Signal_H

#include "waveshor.h"
#include "sfsfunc.h"

class Signal : public WaveShort {
public:
	// constructors + assignment
	Signal(int size=1,double srate=20000) : WaveShort(size,srate,0) {};
	Signal(const WaveShort& isig) : WaveShort(isig) {};
	Signal& operator=(const WaveShort& isig)
	{
		WaveShort::operator=(isig);
		return *this;
	}
	// specialised functions
	void plot(Graph& gr,int gno,const char *pt=0,const char *xt=0,const char *yt=0) const
	{
		WaveShort::plot(gr,gno,(pt)?pt:"Signal",
			(xt)?xt:"Time (s)",(yt)?yt:"Amp");
	};
	int load(const char *fname,const char *spitem,double stime=0,double sdur=-1)
	{
		return SFSLoad(fname,spitem,*this,stime,sdur);
	};
	int save(const char *fname,const char *history) const
	{
		return SFSSave(fname,history,*this);
	};
	int replay() const
	{
		return SFSReplay(*this);
	};
	int record()
	{
		return SFSRecord(*this);
	};
};
#endif
