// WaveShort.h -- definition for dynamic WaveShort class
//
// (c) 1996 Mark Huckvale University College London

// The class WaveShort supports the storage, manipulation, display,
// and replay of short-integer WaveShorts.

#ifndef _WaveShort_H
#define _WaveShort_H

#include "wave.h"

class WaveShort : public Wave {
protected:
	short	*buf;		// WaveShort buffer
public:
	// constructors
	WaveShort(int length=1,double rate=20000.0,int first=0);
	WaveShort(const WaveShort& wv);	// Copy constructor
	~WaveShort();
	// virtual functions
	void dump(int len=-1,int first=0) const;
	void plot(Graph& gr,int gno,const char *title,const char *xt,const char *yt) const;
	// assignment operator
	WaveShort& operator= (const WaveShort& wv);
	// sample access
	short& operator[] (const int idx);
	const short& operator[] (const int idx) const;
	// concatenation
	WaveShort& operator+= (const short val);
	WaveShort& operator+= (const WaveShort& wv);
	WaveShort operator+ (const WaveShort& wv);
	// cut function
	WaveShort cut(int first,int len) const;
	// conversion functions
	WaveDouble toWaveDouble() const;
	WaveComplex toWaveComplex() const;
	// friend functions in SFS library
	friend int SFSLoad(const char *fname,const char *spitem,WaveShort& wv,double stime,double sdur);
	friend int SFSSave(const char *fname,const char *history,const WaveShort& wv);
	friend int SFSReplay(const WaveShort& wv);
	friend int SFSRecord(WaveShort& wv);
};
#endif
