/* sml.h - header file for SML */

#define PROGNAME "sml"
#define PROGVERS "4.3"

/* database definition */
#include "sfs.h"
#include "dig.h"

/* database file item storage */
struct dbitem_rec {
	int			load;
	char			*type;
	struct item_header	item;
	union {
		char		*ptr;
		short		*sp;
		short		*lx;
		int		*tx;
		short		*fx;
		struct an_rec	*an;
		struct lp_rec	*lp;
		short		*sy;
		struct co_rec	*co;
		struct fm_rec	*fm;
		struct pc_rec	*pc;
		float		*tr;
		struct vu_rec	*vu;
		struct di_rec	*di;
	} u;
};
typedef struct dbitem_rec DBITEM;

/* symbol table structure */
typedef struct Symrec {
	char	*name;	/* symbol name */
	int	type;	/* VARTOK, STATTOK, FILETOK, INIT, MAIN, SUMMARY, FUNCTOK,
			   IFTOK, THENTOK, ELSETOK, PRINTTOK, WHILETOK,
			   NUMBER, STRING, UNDEF, DUMMYPAR,
			   VAR, STATVAR, STRVAR, FILEVAR, ITEMVAR,
			   ARRAY, STATARRAY, STRARRAY,
			   FUNCTION, SFUNCTION, BLOCK */
	int	stat;	/* RESERVED, UNDECLARED, LOCAL, GLOBAL */
			/* ADRPAR, VALPAR, BLTIN */
	int	vtype;	/* COUNT, SUM, SUMSQ, MEAN, VARIANCE, STDDEV */
			/* INPFILE, OUTFILE, BADFILE */
			/* CLEARED */
	int	lo,hi;	/* lower and upper bounds of array */
	int	ncol;	/* # columns in 2D array */
	union	{
		double	val;		/* if VAR CONSTANT */
		char	*str;		/* if STR CONSTANT */
		double	(*func)();	/* if FUNCTION */
		char	*(*sfunc)();	/* if STRING FUNCTION */
		FILE	*fil;		/* if FILEVAR */
		DBITEM	*item;		/* if ITEMVAR */
		int	*frame;		/* if block */
		int	*entry;		/* if variable */
	} u;
	union {
		double	gval;		/* global VAR initialisation */
		char	*gstr;		/* global STRVAR initialisation */
	} g;
} Symbol;

/* evaluation stack structure */
typedef struct Stack {
	union {
		double	d;	/* double values */
		char	*s;	/* string pointer */
		void	*v;	/* generic variable pointer (index to symbol table) */
		Symbol	*f;	/* file pointer variables */
	} u;
	int	type;
} Stack;

/* source line recovery structure */
struct	line_rec {
	int	lineno;		/* source line number */
	int	fptr;		/* seek location in source */
	int	pc;		/* program counter */
};


/* annotation table entry */
struct	anntab_entry {
	double	time;
	double	length;
	char	*ann;
};

/* phonetic dictionary */
struct lpdict_rec {
		char	aname[12];
		double	A,B;
};

/* global constants */
#define MAXSYM	10000		/* size of symbol table */
#define MAXCODE 50000		/* size of machine memory */
#define MAXSTACK 5000		/* size of evaluation stack */
#define MAXSTRING 256		/* maximum length of strings returned by string functions */
#define YYMAXDEPTH 300		/* size of Yacc parser stack */
#define MAXRE 100		/* maximum number of REs in match string */
#define MAXSLINES 10000		/* maximum number of source line entries */

/* special characters */
#define ANNSEP 	'\033'		/* ">>" operator becomes ANNSEP in string */
#define ANNSEPS	"\033"		/* string version of ANNSEP */

/* global declarations */
/* Stack types */
#define DOUBLEVAL 0
#define STRINGVAL 1
#define ADDRVAL 2
#define FILEVAL 3
/* stat field values */
#define RESERVED 0
#define UNDECLARED 1
#define ADRPAR 2
#define VALPAR 3
#define LOCAL 4
#define GLOBAL 5
#define BLTIN 6
/* vtype field values */
#define COUNT 0			/* definitions for STAT variables */
#define SUM 1
#define SUMSQ 2
#define MEAN 3
#define VARIANCE 4
#define STDDEV 5
#define NOTYPE 6
#define INPFIL 7		/* file status */
#define OUTFIL 8
#define BADFIL 9
#define INPIPE 10
#define OUTPIPE 11
#define INITEM 12		/* item status */
#define OUTITEM 13		/* item status */
#define BADITEM 14
#define CLEARED -1		/* cleared local variable */

/* machine instructions */
/* 1. VAR access */
#define ADDRVAR 1000
#define ADDRARRAY 1001
#define ADDRELEMENT 1002
#define ADDRELEMENT2 1102
#define LOADVAR 1003
#define STOREVAR 1004
#define LOADVARCONST 1005
/* 2. STR access */
#define ADDRSTR 1006
#define ADDRSTRARRAY 1007
#define ADDRSTRELEMENT 1008
#define ADDRSTRELEMENT2 1108
#define LOADSTR 1009
#define STORESTR 1010
#define LOADSTRCONST 1011
/* 3. STAT access */
#define ADDRSTAT 1012
#define ADDRSTATFIELD 1013
#define ADDRSTATARRAY 1100
#define ADDRSTATELEMENT 1014
#define ADDRSTATELEMENT2 1114
#define ADDRSTATELEMENTFIELD 1015
#define ADDRSTATELEMENTFIELD2 1115
#define UPDATESTAT 1016
/* 4. FILE access */
#define LOADFILE 1017
#define ASSNFILE 1117
/* 4. major program control */
#define BLOCK 1018
#define CALL 1019
#define RETURN 1020
#define SRETURN 1120
#define NEXTIPFILE 1021
#define CLOSEDOWN 1022
#define STOP 1023
#define EXIT 1123
/* 5. procedural control */
#define GOTO 1024
#define CONDITION 1025
#define WHILECODE 1026
#define FORCODE 1027
#define WITH 1028
#define WITHN 1029
#define WITHIN 1030
#define CLEAR 1031
#define CLEARARRAY 1032
#define CLEARELEMENT 1033
#define CLEARELEMENT2 1133
#define ABORT 1034
#define ABORTTEST 1035
#define SWITCH 1136
#define CASE 1137
#define STRCASE 1138
#define RANGECASE 1139
#define DEFCASE 1140
#define PATCASE 1141
/* 6. arithmetic */
#define PLUS 1036
#define MINUS 1037
#define TIMES 1038
#define DIVIDE 1039
#define NEGATE 1040
#define MODULUS 1142
/* 7. conditional expressions */
#define GTCODE 1041
#define GECODE 1042
#define LTCODE 1043
#define LECODE 1044
#define EQCODE 1045
#define NECODE 1046
#define ORCODE 1047
#define ANDCODE 1048
#define NOTCODE 1049
#define ERRCHECK 1050
/* 8. string operations */
#define STRCAT 1051
#define STRSCAT 1052
#define STRCUT 1153
#define STRCUT2 1154
/* 9. i/o operations */
#define PRINTVAL 1053
#define PRINTVAL1 1054
#define PRINTVAL2 1055
#define PRINTSTR 1056
#define PRINTSTR1 1057
#define INPUTLINE 1158
#define READVAL 1058
#define READSTR 1059
#define READLINE 1160
/* misc */
#define LOBOUND 1060
#define HIBOUND 1061
#define TRACEON 1062
#define TRACEOFF 1063
#define BREAK 1064

/* sml - global data */

/* execution profile */
char	*progname;		/* program name */
int	gargc;			/* global argument count */
char	**gargv;		/* global argument list */
char	*cltype[MAXDATATYPE+1];	/* command line specs */
char	dictionary[80];		/* phonetic dictionary name */
int	filereport;		/* report file errors */
int	runtrace;		/* trace level */
int	startnew;		/* symbol table dump start */

/* input program file */
FILE	*ip;			/* source file ptr */
char	sfilename[256];		/* source file name */
#define MAXFSTACK 5
FILE 	*fstack[MAXFSTACK];	/* input source file stack */
int 	fstackptr;		/* source file stack pointer */

/* parsing */
Symbol	stab[MAXSYM];		/* symbol table */
int	scnt;			/* symbol count */
int	symreserve;		/* split system/user symbols */
int	begline;		/* line start flag */
int	errors;			/* compilation errors */
int	memory[MAXCODE];	/* intermediate code */
int	pc;			/* program counter */
int	yylval;			/* symbol value from lex */
int	globalflag;		/* global/local data block */
int	vardecflag;		/* data block type */
int	mainpc;			/* main restart pc */
int	maindata;		/* main data entry */
struct line_rec sline[MAXSLINES];	/* code:source map */
int	slent;			/* code:source map pointer */
int	outputvar,inputvar;	/* i/o variables */
int	currfunc;		/* current function */
int	parnum;			/* current parameter number */
int	switchtype;		/* 'switch' statement type */

/* execution */
Stack	stack[MAXSTACK];	/* execution stack */
int	sp;			/* stack pointer */
char 	ERRSTRING[10];		/* standard error string */
double	ERRVAL;			/* standard error value */
double	timerange[10][2];	/* "with" time ranges */
int	tr;			/* time range stack pointer */
char	*cfilename;	/* name of current file */
int	filecount;		/* data file count */
int	graphicson;		/* graphics used */
int	lineno;			/* current line number */
int	inmain;			/* executing main procedure */
char	lasterr[1024];	/* last error */

/* data file access */
char	*ittype[MAXDATATYPE+1];	/* loaded data types */
char	dbfilename[256];	/* data file name */
int	dbfid;			/* data file descriptor */
struct main_header head;	/* data file main header */
struct dbitem_rec dbitem[MAXDATATYPE+1];/* data set descriptor table */
#define MAXATTR 76
struct lpdict_rec lpdict[MAXATTR];	/* LP dictionary */
int	lpdictlen;		/* LP dictionary length */
int	lpdictload;		/* LP dictionary loaded */

/* annotation data */
int	anncnt;
struct anntab_entry *anntab;

/* function declarations */
#ifdef __STDC__
/* lex.c */
int yylex(void);
int backslash(int c);
int follow(int expect,int ifyes,int ifno);
void dumpsline(void);
char *homedir(void);
void looklib(int entry);
/* init.c */
void init(void);
/* symbol.c */
int lookup(char *s);
int install(char *s,int ty,double vl);
void dummysym(void);
void dumpstab(void);
void settype(int entry,int t,int g);
void setarrtype(int entry,int lonum,int hinum,int t,int g);
void setfunctype(int ent,int t,int loc);
void setblock(int entry);
void clearlocals(void);
void checkpars(void);
void checkreturn(int entry,int t);
void checkcall(int entry,int last);
int patcomp(int entry);
void addglobal(char *str);
void initglobal(void);
/* code.c */
void code(int inst);
void callcode(int *pnum,int t,int inst,int entry);
void dumpscode(char *filename);
void dumpcode(void);
int printinstr(FILE *fil,int i);
void push(double d);
double pop(void);
void vpush(void *v);
void *vpop(void);
void fpush(Symbol *f);
Symbol *fpop(void);
void spush(char *s);
char *spop(void);
int arrayindex(int lo,int hi,double val);
void prepare(void);
int run(int p);
void unblock(int s1,int s2);
void runtimewarning(char *s,char *t);
char *nextfile(int argc,char **argv);
/* malloc.c */
char *Malloc(int n);
void Free(char *a);
char *Calloc(int n,int m);
/* regexp.c */
#include "regexp.h"
/* dbits.c */
int opendbfile(char *f,int clr);
int loadann(void);
int loadnextit(int it,int ty);
int loadit(int it);
void unloadit(int it);
int loadlpdict(void);
void closedbfile(void);
/* graph.h */
double Plotparam(void);
double Plotxdata(void);
double Plot(void);
double Plotclear(void);
double Plotaxes(void);
double Plottitle(void);
double Plotwait(void);
double Plotend(void);
/* function.c */
double Sqrt(void), Log(void), Exp(void), Abs(void), Int(void), Time(void), Length(void), Numberof(void);
double Log10(void),Sin(void),Cos(void),Tan(void),Asin(void),Acos(void),Atan(void),Atan2(void),Pow(void);
double Srandom(void),Random(void);
double Index(void),Compare(void),Tx(void),Fx(void),Tr(void);
double Sy(void),F1(void),A1(void),B1(void),F2(void),A2(void),B2(void),F3(void),A3(void),B3(void),F4(void),A4(void),B4(void);
double Lp(void),Energy(void),Fm(void),Vu(void),Sp(void),Pc(void),Co(void);
double Lengthn(void),Timen(void),Select(void),Selectitem(void),Selectnext(void),Selectmatch(void),Next(void);
double System(void),Stopwatch(void),Val(void),Ascii(void),Strlen(void);
char   *Match(void),*Matchn(void),*History(void),*Str(void),*Istr(void),*Char(void);
double Openin(void),Openout(void),Openappend(void),Close(void);
double SFSGetItem(void),SFSGetItemHeaderField(void),SFSGetItemData(void);
double SFSNewItem(void),SFSPutItem(void),SFSSetItemData(void);
double SFSGetItemField(void),SFSSetItemField(void),SFSDuplicateItem(void);
double SFSProcessItem(void),SFSSetItemString(void);
double SFSGetItemArray(void);
char * SFSGetItemHeaderString(void);
double SFSSetItemHeaderString(void);
char * SFSGetItemString(void);
double Entry(void);
long times(long *buff);
int annmatch(char *s,int start,int *first,int *last);
int itcode(int it,int ty,double *val);
int itdecode(double val,int *it,int *ty);
double Ttest01(double *s1,double *s2);
double Correl(double *s1,double *s2,double *p);
double Anovar(double *s,int l);
double	FFTransform(void);

/* sml.y */
void ppush(int);
int ppop(void);
void yyerror(char *s);
void warning(char *s,char *t);


#else
#endif

/* sml.h - header ends */
