# span shell script
#
set preproc=""
set command = `getopt "Ip" $*`
if ($#command == 0) then
	echo "usage: span (-I) prog.spn"
	exit 1
endif
while ($command[1]:q != "--")
	switch ($command[1]:q)
	case "-I":
		echo span: C-SPAN language compiler Vs 1.0
		exit 0
	case "-p":
		set preproc="y"
	endsw
	shift command
end
shift command
if ($#command == 0) then
	echo "usage: span (-I) prog.spn"
	exit 1
endif
#
# get basename of file
#
set filename=`basename $command[1] .spn`
#
# make C program
#
set cfilename=${filename}.c
echo "#include" '"spandrv.h"' >$cfilename
echo "#include" '"'$command[1]'"' >>$cfilename
echo "char *sourcename=" '"'$command[1]'";' >>$cfilename
#
# compile it
#
if ($preproc:q != "") then
gcc -E -I$SFSBASE/include $cfilename >${filename}.i
else
gcc -I$SFSBASE/include $cfilename $SFSBASE/lib/spandrv.a $SFSBASE/lib/libsfs.a /usr/demo/SOUND/libaudio.a -lm -o $filename
endif
#
# delete source and object
rm -f $cfilename ${filename}.o
