@echo off
rem SFS demonstration control for DOS
rem ---------------------------------
rem
rem Check environment variables set
if %SFSBASE%x == x goto nobase
if %GTERM%x == x goto nogterm
if %DAC%x == x goto nodac
rem
rem Check signal file is there
if not exist life01.bin goto nolife
rem
rem Check programs there
if not exist %SFSBASE%\bin\hed.exe goto noprog
if not exist %SFSBASE%\bin\slink.exe goto noprog
if not exist %SFSBASE%\bin\summary.exe goto noprog
if not exist %SFSBASE%\bin\sdump.exe goto noprog
if not exist %SFSBASE%\bin\ds.exe goto noprog
if not exist %SFSBASE%\bin\es.exe goto noprog
if not exist %SFSBASE%\bin\replay.exe goto noprog
if not exist %SFSBASE%\bin\fxac.exe goto noprog
if not exist %SFSBASE%\bin\fmanal.exe goto noprog
if not exist %SFSBASE%\bin\resamp.exe goto noprog
if not exist %SFSBASE%\bin\spectran.exe goto noprog
if not exist %SFSBASE%\bin\dicode.exe goto noprog
if not exist %SFSBASE%\bin\prolab.exe goto noprog
rem
rem create an SFS file
if exist sfsdemo.sfs del sfsdemo.sfs
%SFSBASE%\bin\prolab %SFSBASE%\data\labels
cls
echo 1. Create an empty SFS file
echo ---------------------------
echo 
echo *** This creates a file SFSDEMO.SFS that is empty apart
echo *** from the main header.  We create it and then list
echo *** contents of the main header.
pause
%SFSBASE%\bin\hed -n sfsdemo.sfs
%SFSBASE%\bin\sdump -h sfsdemo.sfs
echo 
echo *** This 'dump' listing shows the contents of the header fields.
pause
cls
echo 2. Fill header fields with useful information
echo ---------------------------------------------
echo 
echo *** Here we fill in some of the fields in the main header
echo *** to indicate the user, the source of data, the database,
echo *** the speaker, and the token.
pause
%SFSBASE%\bin\hed -u you -s UCL -d Temporary -S Mark -t "life /laIf/" sfsdemo.sfs
%SFSBASE%\bin\sdump -h sfsdemo.sfs
pause
cls
echo 3. Import a speech signal from a binary file
echo --------------------------------------------
echo 
echo *** We now import a speech signal from a file already on
echo *** the system.  This file contains the word "life" spoken
echo *** by Mark Huckvale, it is 16-bits/sample, 12800 samples/sec
echo *** and stored in a low-high byte order (correct for DOS).
echo *** This is the file we will use:
dir life01.bin
pause
cls
echo *** We will 'link' it into the SFS file, and then 'summarise'
echo *** the current contents of the file:
echo 
%SFSBASE%\bin\slink -isp -f 12800 life01.bin sfsdemo.sfs
echo *** Summary of SFSDEMO.SFS:
%SFSBASE%\bin\summary sfsdemo.sfs
echo 
echo *** This 'summary' listing shows us what is in the file.  
echo *** Note that the binary file has not been copied.  Instead
echo *** the SFS data item 1.01 points to the binary file.
echo *** The item number shows that the data set is SPEECH and
echo *** that it is the first speech signal in the file.
echo *** The processing history on the right shows where the data
echo *** came from and the parameters used to import it.
pause
cls
echo *** To show that the data has not been copied we can look at
echo *** the size of the SFS file.
dir sfsdemo.sfs
echo 
echo *** You can see that it is much smaller than the binary file
pause
cls
echo 4. Display of the speech signal waveform
echo ----------------------------------------
echo 
echo *** Now we will produce a graphical display of the contents
echo *** of the file with the Ds program.
echo *** Press RETURN to move on from the next screen
pause
%SFSBASE%\bin\ds sfsdemo.sfs
echo *** If no graph was displayed, check settings of GTERM variable
pause
cls
echo 5. Replay this speech signal waveform
echo -------------------------------------
echo 
echo *** Now we will replay the speech though the computer's audio
echo *** if such a facility exists on your machine.  For DOS machines
echo *** support is included for SoundBlaster 8 and 16.
echo *** Press '1' RETURN to hear waveform
echo *** Press RETURN to move on
pause
%SFSBASE%\bin\replay -m sfsdemo.sfs
echo 
echo *** If replay did not work, check settings of DAC variable
pause
cls
echo 6. Calculate a fundamental frequency contour
echo --------------------------------------------
echo 
echo *** Here we will run a fundamental frequency estimation
echo *** algorithm based on cepstral analysis.
pause
%SFSBASE%\bin\fxcep sfsdemo.sfs
echo 
echo *** This is the new summary of the file contents
%SFSBASE%\bin\summary sfsdemo.sfs
echo 
echo *** Now we will display the waveform and the fundamental
echo *** frequency contour.
echo *** Press RETURN to exit from next screen
pause
%SFSBASE%\bin\ds sfsdemo.sfs
cls
echo 7. Calculate a set of formant estimates
echo ---------------------------------------
echo 
echo *** Here we will run a formant analysis estimation algorithm
echo *** based on linear prediction and root-solving.
pause
%SFSBASE%\bin\fmanal sfsdemo.sfs
echo 
echo *** This is the new summary of the file contents
%SFSBASE%\bin\summary sfsdemo.sfs
pause
cls
echo *** Now we will display the raw formant data along with 
echo *** the signal and the fundamental frequency estimates
echo *** Press RETURN to exit from next screen
pause
%SFSBASE%\bin\ds sfsdemo.sfs
echo *** The numbers 1-5 represent the frequencies of the first five
echo *** spectral peaks at each 10ms time frame.
echo *** We would expect slightly better results if the signal
echo *** were resampled at 10000 samples/sec.  Let's try it.
pause
cls
echo 8. Change the sampling rate of the signal
echo -----------------------------------------
echo 
echo *** Here we run a sample-rate changing program to change
echo *** the sample rate from 12800 to 10000 samples/sec.
pause
%SFSBASE%\bin\resamp -f 10000 sfsdemo.sfs
echo 
echo *** This is the new summary of the file contents
%SFSBASE%\bin\summary sfsdemo.sfs
echo 
echo *** Notice that we now have two speech waveforms.
pause
cls
echo *** Now we can redo the formant estimates on the resampled
echo *** signal.
pause
%SFSBASE%\bin\fmanal sfsdemo.sfs
echo *** This is the new summary of the file contents
%SFSBASE%\bin\summary sfsdemo.sfs
pause
cls
echo *** Now we will display the two sets of formant data only
echo *** so that we can compare them
echo *** Press RETURN to exit from next screen
pause
%SFSBASE%\bin\ds -afm sfsdemo.sfs
echo *** Notice that the second set of estimates was better.
pause
cls
echo 9. Removing items from the file
echo -------------------------------
echo 
echo *** Let us remove the resampled speech signal and the first
echo *** of the two sets of formant estimates.
echo *** The file currently contains:
%SFSBASE%\bin\summary sfsdemo.sfs
echo 
echo *** Now we remove items 12.01 and 1.02:
pause
%SFSBASE%\bin\remove -i12.01 -i1.02 sfsdemo.sfs
echo 
echo *** This is the new summary of the file contents
%SFSBASE%\bin\summary sfsdemo.sfs
echo 
echo *** Notice that while the first set of formant estimates (12.01) has
echo *** completely disappeared, the second speech signal (1.02) remains
echo *** in a reduced form.  This is so that we can trace the full
echo *** processing history of the set of formant estimates (1.01 to 1.02 to 12.02).
echo *** The item stub for 1.02 only takes up a few bytes.
pause
cls
echo 10. Calculation of a spectrogram
echo --------------------------------
echo 
echo *** We can calculate a spectrogram in two ways: the first is off-line
echo *** so that the spectrogram is stored in the file, the second is
echo *** on-line, so that the spectrogram is calculated while we are
echo *** looking at it.
echo 
echo *** First let's try the off-line method.  To do this we calculate
echo *** a large number of spectra - say 256 point FFTs every millisecond.
echo *** then we turn the spectra into a grey-level picture, then we 
echo *** remove the spectral data.
pause
echo *** Calculating spectra
%SFSBASE%\bin\spectran -s1 sfsdemo.sfs
echo *** Calculating grey-level picture
%SFSBASE%\bin\dicode sfsdemo.sfs
echo *** Removing spectral coefficients
%SFSBASE%\bin\remove -ico sfsdemo.sfs
echo 
echo *** This is the new summary of the file contents
%SFSBASE%\bin\summary sfsdemo.sfs
echo 
echo *** The spectrogram is stored in the 'display' item 9.01.
echo *** Note how the spectral data (11.01) is also retained as a 'stub'.
echo *** Now let us display the waveform, the formant estimates
echo *** and the spectrogram.
pause
%SFSBASE%\bin\ds -isp -ifm -idi sfsdemo.sfs
cls
echo *** Now let us try the on-line method.  Here the computer will
echo *** calculate a spectrogram for us while we move around the file.
echo *** This demonstration uses Es, the main interactive display
echo *** program of SFS.  To use it in this demonstration, you need to
echo *** take note of the following commmands:
echo *** 1. left mouse button = left cursor
echo *** 2. right mouse button = right cursor
echo *** 3. middle mouse button = replay
echo *** ZOOM option = zoom in to region between cursors
echo *** MOVE option (left button = scroll left, right button - scroll right)
echo *** QUIT option = stop program
echo 
echo *** We use Es to display the waveform, the formant estimates and
echo *** an on-line spectrogram.
echo *** Click the QUIT option, or press 'q' to stop Es.
pause
%SFSBASE%\bin\es -isp -ifm -gsp sfsdemo.sfs
cls
echo *** SFS demonstration complete
echo 
echo *** There is another demonstration in the SFS User Manual which leads
echo *** you through some basic SFS commands.
goto end
rem ------------------------------------
:nobase
echo SFSBASE variable not set
echo It should be set to the name of the SFS base directory
goto end
rem ------------------------------------
:nogterm
echo GTERM variable not set
echo It should be set to the graphics type.  E.g. vga-16 or svga-256.
goto end
rem ------------------------------------
:nodac
echo DAC variable not set
echo It should be set to the soundcard type.  E.g. sb8 or sb16.
goto end
rem ------------------------------------
:nolife
echo life01.bin data file missing
goto end
rem ------------------------------------
:noprog
echo SFS executable file missing
goto end
rem ------------------------------------
:end
if exist sfsdemo.bak del sfsdemo.bak
