function exitcode=hilbertex(fname,ilist,plist)
% HILBERTEX calculates instantaneous frequency of a signal using
% Hilbert transform
%
%   exitcode=HILBERTX(fname,ilist,plist) performs a Hilbert transform on
%   the speech signal specified by ilist in the SFS file fname.  The 
%   instantaneous frequency is returned as a TRACK item in the file.
%   There are no current parameters supported for plist.  
%
addpath('\sfs\matlab');
%
% sort out items
%
if (isempty(ilist)) ilist=[1]; end;
%
% get item
%
version
display(fname);
display(ilist(1));
display(num2str(ilist(1)));
%
[h,d]=sfsgetitem(fname,num2str(ilist(1)));
%
% do hilbert transform
%
y=hilbert(d);
%
% calculate instantaneous frequency
%
f=abs(diff(unwrap(angle(y)))/(2*pi*h.frameduration));
%
% return as TRACK item
%
[oh,od]=sfsnewitem(16,h.frameduration,h.offset,1,length(f));
sfsputitem(fname,oh,f);
exitcode=0;
