function newsfsfile(fname)
% NEWSFSFILE(fname) attempts to create an SFS file called fname
%
%   If the file fname exists and is an SFS file, then it is 
%   just emptied of its current contents

status=sfsfile(fname);
if (status == -1)
	% doesn't exist
	sfsfile(fname,'create');
elseif (status == -2)
	% exists but not SFS
	delete(fname);
	sfsfile(fname,'create');
else
	% exists and is SFS
	sfsfile(fname,'empty');
end