function exitcode=sfsfilterex(fname,ilist,plist)
% SFSFILTEREX runs the SFSFILTER function using MATLABEX
%
%   Options:
%      -i item         select input speech item
%      -l lowfreq      specify a low frequency edge
%      -h highfreq     specify a high frequency edge
%
%   For example:
%      -l 500          low-pass at 500Hz
%      -h 1000         high-pass at 1000Hz
%      -l 100 -h 200   band-pass between 100 and 200
%      -h 200 -l 100   band-stop between 100 and 200

%
% sort out items
%
if (isempty(ilist)) ilist=[1]; end;
%
% sort out filter
%
lofreq=-1;
hifreq=-1;
for i=1:length(plist)
    if (strcmp(plist(i).param,'-l'))
        lofreq=str2num(plist(i).value);
    end;
    if (strcmp(plist(i).param,'-h'))
        hifreq=str2num(plist(i).value);
    end;
end;
%
% call function
%
if ((lofreq==-1) & (hifreq==-1))
    fprintf('no cut-off frequencies specified!\n');
elseif (hifreq==-1)
    sfsfilter(fname,num2str(ilist(1)),lofreq,'low');
elseif (lofreq==-1)
    sfsfilter(fname,num2str(ilist(1)),hifreq,'high');
elseif (lofreq < hifreq)
    sfsfilter(fname,num2str(ilist(1)),[lofreq hifreq],'band');
else
    sfsfilter(fname,num2str(ilist(1)),[hifreq lofreq],'stop');
end
%
exitcode=0;
