function summary(fname)
% SUMMARY Display summary of data items in an SFS file
%
%   SUMMARY('file.sfs') will produce a listing of the item numbers,
%   number of frames and processing history for each item in file.sfs

ilist=sfsfile(fname);
if (ilist < 0)
    fprintf('error accessing "%s"\n',fname)
else
    fprintf('SFS file "%s" contains:\n',fname)
    for i=1:length(ilist)
        h=sfsgetitem(fname,num2str(ilist(i)));
        fprintf('%2d.%02d %6d frames %s\n',...
            h.datatype,h.subtype,h.numframes,h.history);
    end
end
