function [header,data]=sfsgetitem(filename,itemsel)
% SFSGETITEM reads in a data set from an SFS file.
%
%   [h,d]=SFSGETITEM(filename,itemsel) will read the data set
%   header into a structure h, and the data set itself into the
%   array d.  The itemsel string can be either a string version
%   of the item number (use NUM2STR() to convert item number), or
%   an item type short code, or one of the other item selection
%   schemes as described in the SFS manual.  Use the SFSFILE()
%   function to get a list of item numbers in the file.  Look at
%   the SFS programmers manual for information about the meaning
%   of the fields in the header structure.
%
%   h=SFSGETITEM(filename,itemsel) just reads the header of the
%   data set.
%
%   The following fields are defined in the header structure:
%       history       - process history
%       params        - process parameters
%       processdate   - process date
%       datatype      - data set main type
%       subtype       - data set number
%       floating      - 1=floating,0=integer,-1=structured
%       datasize      - element data size
%       framesize     - number of elements per frame
%       numframes     - number of frames
%       length        - total length of data set in bytes
%       frameduration - duration of one frame
%       offset        - time offset of data set
%       datapresent   - present/deleted/linked flag
%       windowsize    - number frames in one window
%       overlap       - number of frames in window overlap
%       lxsync        - pitch synchronous
%       lastpos       - last known sample position
%
%   The data format for common SFS data types is as follow
%      1. SPEECH:  column vector
%      2. LX:      column vector
%      3. TX:      column vector
%      4. FX:      column vector
%      5. ANNOT:   array of structures (posn, size, label)
%      6. SYNTH:   array of numframes rows, framesize columns
%      9. DISPLAY: array of numframes rows, (framesize+2) columns
%                  col1=posn, col2=size
%     10. VU:      array of numframes rows, (framesize+5) columns
%                  col1=posn, col2=size, col3=flag, col4=mix, col5=gain
%     11. COEFF:   array of numframes rows, (framesize+5) columns
%                  col1=posn, col2=size, col3=flag, col4=mix, col5=gain
%     12. FORMANT: array of numframes rows, (framesize+5) columns
%                  col1=posn, col2=size, col3=flag, col4=mix, col5=gain
%                  formant data is stored in column triplets: freq,amp,band
%     16. TRACK:   column vector
%
%   See also: SFSFILE(), SFSGETITEM(), SFSNEWITEM(), SFSPUTITEM()
