// annot.cpp -- implementation of SFS annotation access class
//
// C++ (c) 1996 Mark Huckvale University College London

#include <iostream>
#include "tools.h"
#include "annot.h"
#include <string.h>
#include "sfsfunc2.h"

// constructors
AnnotationList::AnnotationList(int size)
{
	table = new Annotation[size];
	num = size;
	for (int i=0;i<num;i++) table[i].name = 0;
}
AnnotationList::AnnotationList(const AnnotationList& an)
{
	table = new Annotation[an.size()];
	num = an.size();
	for (int i=0;i<num;i++) {
		if (an.table[i].name) {
			table[i].name = new char[strlen(an.table[i].name)+1];
			strcpy(table[i].name,an.table[i].name);
		}
		else
			table[i].name = 0;
	}
}
AnnotationList::~AnnotationList()
{
	for (int i=0;i<num;i++) delete table[i].name;
	delete [] table;
}
AnnotationList& AnnotationList::operator=(const AnnotationList& an)
{
	int	i;
	if (&an==this) return *this;
	for (i=0;i<num;i++) delete table[i].name;
	delete [] table;
	table = new Annotation[an.size()];
	num = an.size();
	for (i=0;i<num;i++) {
		if (an.table[i].name) {
			table[i].name = new char[strlen(an.table[i].name)+1];
			strcpy(table[i].name,an.table[i].name);
		}
		else
			table[i].name = 0;
	}
	return *this;
}

// access an element
Annotation& AnnotationList::operator[] (const int idx)
{
	static Annotation junk;
	if ((idx >= 0) && (idx < num))
		return table[idx];
	else
		return junk;
}
const Annotation& AnnotationList::operator[] (const int idx) const
{
	static Annotation junk;
	if ((idx >= 0) && (idx < num))
		return table[idx];
	else
		return junk;
}

// find a matching annotation
Annotation& AnnotationList::find(const char *match)
{
	static Annotation junk;
	for (int i=0;i<num;i++)
		if (table[i].name)
			if (strcmp(match,table[i].name)==0)
				return table[i];
	return junk;
}

// file I/O
int AnnotationList::load(const char *fname,const char *anitem)
{
	return SFSLoadAn(fname,anitem,*this);
}
int AnnotationList::save(const char *fname,const char *anitem)
{
	return SFSSaveAn(fname,anitem,*this);
}

