#include "ltisys.h"
#include "ltisysch.h"

ComplexWaveform ButterworthPoles(
	double freq,		// cut-off frequency (fraction)
	int nsection		// number of 2nd order sections reqd
	);			// returns array of pole positions
LTISystemChain ButterworthLowPass(
	double freq,			// cut-off frequency (fraction)
	int nsection			// number of 2nd order sections reqd
	);				// returns array of LTI systems
LTISystemChain ButterworthHighPass(
	double freq,		// cut-off frequency (fraction)
	int nsection		// number of 2nd order sections reqd
	);			// returns array of LTI systems }
LTISystemChain ButterworthBandPass(
	double lofreq,		// low cut-off frequency (fraction)
	double hifreq,		// high cut-off frequency (fraction)
	int nsection		// number of 2nd order sections reqd
	);			// returns array of LTI systems
LTISystemChain ButterworthBandStop(
	double lofreq,		// low cut-off frequency (fraction)
	double hifreq,		// high cut-off frequency (fraction)
	int nsection		// number of 2nd order sections reqd
	);			// returns array of LTI systems
