// conv.cpp -- implementation of Convolution of 2 waveforms
//
// C++ (c) 1996 Mark Huckvale University College London

#include "tools.h"
#include "conv.h"

// The function Convolve performs convolution of two
// time domain waveforms

Waveform Convolve(
	const Waveform& x,	// input waveform
	const Waveform& h	// impulse response
	)			// returns convolved sequence
{
	Waveform y(x.count(),x.rate());

	// for each output sample
	for (int n=1;n<=x.count();n++) {
		y[n] = 0;
		// sum of product with reverse IR
		for (int k=0;k<h.count();k++)
			y[n] += x[n-k] * h[k+1];
			// exploits bad index capability of x[]
	}

	return y;
}
