// ltisys.h -- definition for Linear system class
//
// C++ (c) 1996 Mark Huckvale University College London

// The LTISystem class provides a convenient implementation
// of a linear time-invariant system including estimation
// of frequency response

#ifndef _LTISys_H
#define _LTISys_H

#include "wavedoub.h"
#include "complex.h"

class LTISystem {
public:	// public for demonstration purposes
	WaveDouble	a;	// numerator
	WaveDouble	b;	// denominator
	WaveDouble	s;	// state memory
public:
	// constructors
	LTISystem(int na=0,int nb=0);
	LTISystem(const LTISystem& ltis);
	~LTISystem();
	// assignment
	LTISystem& operator= (const LTISystem& ltis);
	// clear system
	void clear();
	// run system
	double operator() (double ival);
	// frequency response
	Complex response(double freq) const;
};

#endif
