// sfsfunc2.cpp -- SFS interface routines
//
// (c) 1996 Mark Huckvale University College London

// This module allows the loading and saving of annotations
// from/to SFS files.

#include "sfs.h"
#include <iostream>
#include <string.h>
#include "annot.h"
#include "sfsfunc2.h"

using namespace std;

// load a set of annotations
int	SFSLoadAn(const char *fname,const char *anitem,AnnotationList& an)
{
	int	fid;
	int	it;
	char	*ty="0";
	struct item_header item;
	struct an_rec *anrec;
	char	*hold = new char[strlen(anitem)+1];
	strcpy(hold,anitem);

	if (itspec(hold,&it,&ty)!=0) {
		delete [] hold;
		return(-1);
	}
	if (it!=AN_TYPE) {
		delete [] hold;
		return(-2);
	}
	if ((fid=sfsopen((char *)fname,"r",NULL)) < 0) {
		delete [] hold;
		return(-3);
	}
	if (!sfsitem(fid,it,ty,&item)) {
		sfsclose(fid);
		delete [] hold;
		return(-4);
	}
	an = AnnotationList(item.numframes);
	anrec = (struct an_rec *)sfsbuffer(&item,1);
	for (int i=0;i<item.numframes;i++) {
		sfsread(fid,i,1,anrec);
		an[i].name = new char[strlen(anrec->label)+1];
		strcpy(an[i].name,anrec->label);
		an[i].posn = item.offset+anrec->posn*item.frameduration;
		an[i].size = item.offset+anrec->size*item.frameduration;
	}
	free(anrec);
	sfsclose(fid);
	delete [] hold;
	return(0);
}

// save a set of annotations
int	SFSSaveAn(const char *fname,const char *hist,const AnnotationList& an)
{
	int	ofid;
	struct item_header item;
	struct an_rec *anrec;

	sfsheader(&item,AN_TYPE,-1,1,-1,0.00005,0.0,1,0,0);
	strncpy(item.history,hist,sizeof(item.history)-1);

	if ((ofid=sfschannel((char *)fname,&item)) < 0)
		return(-6);
	anrec = (struct an_rec *)sfsbuffer(&item,1);
	for (int i=0;i<an.size();i++) {
		strcpy(anrec->label,an[i].name);
		anrec->posn = (int)(0.5+an[i].posn/0.00005);
		anrec->size = (int)(0.5+an[i].size/0.00005);
		if (sfswrite(ofid,1,anrec)!=1) {
			sfsclose(ofid);
			free(anrec);
			return(-7);
		}
	}
	free(anrec);
	if (!sfsupdate((char *)fname))
		return(-8);
	return(0);
}

#ifdef EMO
int main()
{
	AnnotationList an(1);

	cout << "SFSLoadAn(\"test.sfs\",\"an.\",an) returns " <<
		SFSLoadAn("test.sfs","an.",an) << "\n";

	for (int i=0;i<an.size();i++)
		cout << an[i].posn << '\t' << an[i].size << '\t' << an[i].name << '\n';

	// reverse labels
	for (int i=0;i<an.size();i++) {
		for (int j=0;j<strlen(an[i].name)/2;j++) {
			char t = an[i].name[j];
			an[i].name[j] = an[i].name[strlen(an[i].name)-j-1];
			an[i].name[strlen(an[i].name)-j-1] = t;
		}
	}

	cout << "SFSSaveAn(\"test.sfs\",\"sfsfunc2()\",an) returns " <<
		SFSSaveAn("test.sfs","sfsfunc2()",an) << "\n";

}
#endif
