/* graph -- plotting routines for sml */

#include <stdio.h>
#include <math.h>
#include "sml.h"
#include "dig.h"
#include "dgraph.h"

/* x-y plotting data */
static	double	xinit[2]={0.0,1.0};
static  char	plotchar[2] = {'\0', '\0' };
static	char	nulstr[1] = {'\0'};
static	struct {
	double	*xdata;
	double	*ydata;
	int	nxy;
	int	nvert;
	int	nhoriz;
	int	gno;
	int	xmode;
	int	ymode;
	int	gtype;
	int	dobox;
	char	*pt,*xt,*yt,*title;
} pd = {
	xinit,NULL,0,
	1,1,1,
	DGdouble|DGinc|DGlowax|DGlowlab,
	DGdouble|DGlowax|DGhighlab,
	DGline,0,
	NULL,nulstr,nulstr,nulstr
};

#define MAXHORIZ	10
#define MAXVERT		10
int	gused[MAXHORIZ*MAXVERT];

/* x-y plotting routines */
double	Plotparam()
{
	char	*s;		/* parameter string */
	char	*p,*v;		/* parameter name & value */
	char	*Malloc();

	s = spop();
	if (s==ERRSTRING) return(ERRVAL);

	/* get parameter */
	p = s;
	while (*s && (*s != '=')) s++;
	if (*s != '=') {
		Free(p);
		return(ERRVAL);
	}
	*s++='\0';
	v = s;

	/* decode parameter string */
	if (!strcmp(p,"vertical")) {
		pd.nvert=atoi(v);
		if (pd.nvert <= 0)
			pd.nvert=1;
		else if (pd.nvert > MAXVERT)
			pd.nvert=MAXVERT;
	}
	else if (!strcmp(p,"horizontal")) {
		pd.nhoriz=atoi(v);
		if (pd.nhoriz<=0)
			pd.nhoriz=1;
		else if (pd.nhoriz > MAXHORIZ)
			pd.nhoriz = MAXHORIZ;
	}
	else if (!strcmp(p,"type")) {
		if (!strcmp(v,"point")) pd.gtype=DGpoints;
		else if (!strcmp(v,"line")) pd.gtype=DGline;
		else if (!strcmp(v,"hist")) pd.gtype=DGhist;
		else if (!strcmp(v,"histend")) pd.gtype=DGhistend;
		else if (!strcmp(v,"histdiv")) pd.gtype=DGhistdiv;
		else if (!strcmp(v,"bar")) pd.gtype=DGbar;
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"char")) {
		plotchar[0] = v[0];
		if (v[0])
			pd.pt = plotchar;
		else
			pd.pt = NULL;
	}
#if 0
	else if (!strcmp(p,"npoint")) pd.isymb = (pd.isymb & 0xFF) + (atoi(v)<<8);
#endif
	else if (!strcmp(p,"box")) {
		if (v[0]=='n')
			pd.dobox = 0;
		else if (v[0]=='y')
			pd.dobox = 1;
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"xzero")) {
		if (v[0]=='y')
			pd.xmode |= DGzero;
		else if (v[0]=='n')
			pd.xmode &= ~DGzero;
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"yzero")) {
		if (v[0]=='y')
			pd.ymode |= DGzero;
		else if (v[0]=='n')
			pd.ymode &= ~DGzero;
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"xpos")) {
		if (v[0]=='b') {
			pd.xmode &= ~DGhighax;
			pd.xmode |= DGlowax;
		}
		else if (v[0]=='t') {
			pd.xmode &= ~DGlowax;
			pd.xmode |= DGhighax;
		}
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"ypos")) {
		if (v[0]=='l') {
			pd.ymode &= ~DGhighax;
			pd.ymode |= DGlowax;
		}
		else if (v[0]=='r') {
			pd.ymode &= ~DGlowax;
			pd.ymode |= DGhighax;
		}
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"xlabel")) {
		if (v[0]=='b') {
			pd.xmode &= ~DGhighlab;
			pd.xmode |= DGlowlab;
		}
		else if (v[0]=='t') {
			pd.xmode &= ~DGlowlab;
			pd.xmode |= DGhighlab;
		}
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"ylabel")) {
		if (v[0]=='l') {
			pd.ymode &= ~DGlowlab;
			pd.ymode |= DGhighlab;
		}
		else if (v[0]=='r') {
			pd.ymode &= ~DGhighlab;
			pd.ymode |= DGlowlab;
		}
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"xscale")) {
		if (v[0]=='n')
			pd.xmode |= DGnoscale;
		else if (v[0]=='y')
			pd.xmode &= ~DGnoscale;
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"yscale")) {
		if (v[0]=='n')
			pd.ymode |= DGnoscale;
		else if (v[0]=='y')
			pd.ymode &= ~DGnoscale;
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"xlog")) {
		if (v[0]=='n')
			pd.xmode &= ~DGlogax;
		else if (v[0]=='y')
			pd.xmode |= DGlogax;
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"ylog")) {
		if (v[0]=='n')
			pd.ymode &= ~DGlogax;
		else if (v[0]=='y')
			pd.ymode |= DGlogax;
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"equal")) {
		if (v[0]=='y')
			pd.xmode |= DGequal;
		else if (v[0]=='n')
			pd.xmode &= ~DGequal;
		else {
			Free(p);
			return(ERRVAL);
		}
	}
	else if (!strcmp(p,"xtitle")) {
		if (pd.xt != nulstr) Free(pd.xt);
		pd.xt = Malloc(strlen(v)+1);
		strcpy(pd.xt,v);
	}
	else if (!strcmp(p,"ytitle")) {
		if (pd.yt != nulstr) Free(pd.yt);
		pd.yt = Malloc(strlen(v)+1);
		strcpy(pd.yt,v);
	}
	else if (!strcmp(p,"title")) {
		if (pd.title != nulstr) Free(pd.title);
		pd.title = Malloc(strlen(v)+1);
		strcpy(pd.title,v);
	}
	else {
		Free(p);
		return(ERRVAL);
	}

	Free(p);
	return(0.0);
}

double	Plotxdata()
{
	double	*a;
	int	l,h,n,flag;
	double	d;

	d = pop();
	n = (int)vpop();
	h = (int)vpop();
	l = (int)vpop();
	a = (double *)vpop();
	if ((d==ERRVAL) || (d<0) || (d>2)) return(ERRVAL);

	pd.xdata = a;
	flag = (int)d;
	if (flag==0) {
		pd.xmode &= ~(DGfirst|DGnext|DGlast);
	}
	else if (flag==1) {
		pd.xmode &= ~(DGfirst|DGnext|DGlast);
		pd.xmode |= DGlast;
	}
	else {
		pd.xmode &= ~(DGfirst|DGnext|DGlast);
		pd.xmode |= DGinc;
	}
	return(0.0);
}

double Plot()
{
	Symbol	*sym;
	double	gno,num;
	double	*a;
	int	l,h,n;
	int	gx,gy;

	num = pop();
	n = (int) vpop();
	h = (int) vpop();
	l = (int) vpop();
	a = (double *) vpop();
	gno = pop();
	sym = fpop();

	if ((num==ERRVAL) || (gno==ERRVAL)) return(ERRVAL);
	if ((sym->vtype != OUTFIL) && (sym->vtype != OUTPIPE)) {
		runtimewarning("file not open for output","");
		return(ERRVAL);
	}
	pd.ydata = a;
	pd.nxy = (int) num;
	pd.gno = (int) gno;

	/* init graphics */
	digstart(DIG_DEFAULT_TERM,sym->u.fil,1);
	graphicson=1;		/* flag to ensure a digend is done */

	digscale((float)pd.nhoriz,1.2*(float)pd.nvert,0);
	gx = ((int)(0.5+gno-1)) % pd.nhoriz;
	gy = ((int)(0.5+gno-1)) / pd.nhoriz;
	digorigin((float)gx,1.1*((float)pd.nvert-gy-1));

	if (gused[(int)gno])
		dgraph((short *)pd.xdata,(short *)pd.ydata,pd.nxy,
			pd.xmode|DGprev,pd.ymode|DGprev,pd.gtype,23242423+gused[(int)gno],
			pd.pt,pd.xt,pd.yt);
	else
		dgraph((short *)pd.xdata,(short *)pd.ydata,pd.nxy,
			pd.xmode,pd.ymode,pd.gtype,23242423,
			pd.pt,pd.xt,pd.yt);

	if (pd.title && pd.title[0])
		digboxtext(24,0.5,1.02,0.7,0.07,0.0,pd.title,1);

	if (pd.dobox) digbox(24,0.0,0.0,1.0,1.1);

	digflush();

	gused[(int)gno]++;
	return(0.0);
}

/* clear screen */
double Plotclear()
{
	Symbol	*sym;

	sym = fpop();
	if ((sym->vtype != OUTFIL) && (sym->vtype != OUTPIPE)) {
		runtimewarning("file not open for output","");
		return(ERRVAL);
	}
	digstart(DIG_DEFAULT_TERM,sym->u.fil,1);

	digclearscreen();
	memset(gused,0,sizeof(gused));

	graphicson=1;
	return(0.0);
}

double Plotaxes()
{
	Symbol	*sym;
	double	gno;
	double	xmin,xmax,ymin,ymax;
	int	gx,gy;
	double	x[2],y[2];

	ymax = pop();
	ymin = pop();
	xmax = pop();
	xmin = pop();
	gno = pop();
	sym = fpop();

	if ((xmin==ERRVAL) || (xmax==ERRVAL) ||
	    (ymin==ERRVAL) || (ymax==ERRVAL) || (gno==ERRVAL)) return(ERRVAL);
	if ((sym->vtype != OUTFIL) && (sym->vtype != OUTPIPE)) {
		runtimewarning("file not open for output","");
		return(ERRVAL);
	}
	pd.gno = (int) gno;

	/* init graphics */
	digstart(DIG_DEFAULT_TERM,sym->u.fil,1);
	graphicson=1;		/* flag to ensure a digend is done */

	digscale((float)pd.nhoriz,1.2*(float)pd.nvert,0);
	gx = ((int)(0.5+gno-1)) % pd.nhoriz;
	gy = ((int)(0.5+gno-1)) / pd.nhoriz;
	digorigin((float)gx,1.1*((float)pd.nvert-gy-1));

	x[0]=xmin; x[1]=xmax;
	y[0]=ymin; y[1]=ymax;
	dgraph((short *)x,(short *)y,2,
		(pd.xmode & ~(DGfirst|DGnext))|DGlast,(pd.ymode & ~(DGfirst|DGnext))|DGlast,DGaxonly,23242423,
		pd.pt,pd.xt,pd.yt);

	if (pd.dobox) digbox(24,0.0,0.0,1.0,1.1);

	digflush();

	gused[(int)gno]++;
	return(0.0);
}

double Plottitle()
{
	Symbol	*sym;
	char	*s;

	s = spop();
	sym = fpop();

	if (s==ERRSTRING) return(ERRVAL);

	if ((sym->vtype != OUTFIL) && (sym->vtype != OUTPIPE)) {
		runtimewarning("file not open for output","");
		return(ERRVAL);
	}

	/* init graphics */
	digstart(DIG_DEFAULT_TERM,sym->u.fil,1);
	graphicson=1;		/* flag to ensure a digend is done */

	digscale(1.0,1.2,0);
	digorigin(0.0,0.0);
	digboxtext(24,0.5,1.13,0.7,0.06,0.0,s,1);

	digflush();

	return(0.0);
}

/* wait for key press */
double Plotwait()
{
	Symbol	*sym;

	sym = fpop();
	if ((sym->vtype != OUTFIL) && (sym->vtype != OUTPIPE)) {
		runtimewarning("file not open for output","");
		return(ERRVAL);
	}

	if (graphicson) digwait();

	return(0.0);
}

/* close down graphics */
double Plotend()
{
	Symbol	*sym;

	sym = fpop();
	if ((sym->vtype != OUTFIL) && (sym->vtype != OUTPIPE)) {
		runtimewarning("file not open for output","");
		return(ERRVAL);
	}

	if (graphicson) digquit(1);
	graphicson=0;
	memset(gused,0,sizeof(gused));

	return(0.0);
}


