/* prw.h -- pattern recognition workbench standard definitions */

/* version 2 - July 1994 */

/* configuration */
#include "SFSCONFG.h"

/* manifest constants */
#define MAXTEXTLINE	163840
#define MAXVECTOR	8192
#define MAXLABEL	256
#define MAXLABELNAME	16
#define CACHESIZE	(2*MAXVECTOR)
#define MIN(x,y)	(((x)<(y))?(x):(y))
#define MAX(x,y)	(((x)>(y))?(x):(y))
#define PERCENT(x,y)	((float)(x)*100.0/(float)(y))
#define MAXDISCRETE	MAXLABEL

#define PRW_MAGIC 0x5058	/* magic number 'PX' */

/* labels file header */
struct labels_header_file {
	short	magic;		/* magic number identifies file has header */
	short	version;	/* room for revision info */
	long	start;		/* byte offset of 1st label record */
	double	frameduration;	/* time scaling factor */
	long	count;		/* number of label records in file (may be 0=unknown) */
	short	recsize;	/* size of label records in file */
	short	labmode;	/* format of labels:
					0 = continuous
					1 = discrete	*/
	short	vecmode;	/* format of vectors:
					0 = floating point values
					1 = bytes
					2 = shorts */
	short	labnum;		/* number of text labels:
					= # labels per record / continuous
					= # values of label / discrete */
	short	vecsize;	/* size of vectors (bytes) */
	char	filler[8];	/* room for expansion */
	/* followed by 'labnum' NULL terminated strings */
};
struct labels_header {
	short	magic;		/* magic number identifies file has header */
	short	version;	/* room for revision info */
	long	start;		/* byte offset of 1st label record */
	double	frameduration;	/* time scaling factor */
	long	count;		/* number of label records in file (may be 0=unknown) */
	short	recsize;	/* size of label records in file */
	short	labmode;	/* format of labels:
					0 = continuous
					1 = discrete	*/
	short	vecmode;	/* format of vectors:
					0 = floating point values
					1 = bytes
					2 = shorts */
	short	labnum;		/* number of text labels:
					= # labels per record / continuous
					= # values of label / discrete */
	short	vecsize;	/* size of vectors (bytes) */
	char	labels[MAXLABEL][MAXLABELNAME+1];
};

/* structure of labels file */
struct labels_rec {
	long	offset;		/* offset into data file */
	long	posn;		/* position in time */
	short	size;		/* size of this component (bytes) */
 	short 	numset;		/* number of records in set */
	float	label[MAXLABEL];	/* label values */
};
#define LABELS_REC_HEAD_SIZE	12

/* output class information */
#define STATWIDTH	1000
struct classinfo_rec {
	int	*zero;		/* STATWIDTH samples */
	int	tot0;
	int	*one;		/* STATWIDTH samples */
	int	tot1;
	char	label[MAXLABELNAME+1];
};

/* library prototypes */
#ifdef __STDC__
void	patopen(char *,FILE **,FILE **,struct labels_header *);
int	getpattern(FILE *,FILE *,float **,float **,long *posn);
int	getabspattern(FILE *,FILE *,long offset,float **,float **vector);
void	patreset(FILE *);
void	patclose(FILE *,FILE *);
void	gendiscretelabel(float,float *,int);
#endif
