/* filter.h -- General Purpose Digital Filter Routines */

/* Mark Huckvale - University College London */

/* maximum sizes */
#define FILTER_MAX_ORDER	20

/* filter types */
#define FILTER_LOW_PASS		1
#define FILTER_HIGH_PASS	2
#define FILTER_BAND_PASS	3
#define FILTER_BAND_STOP	4

/* structure of a filter section */
typedef struct FILTER_SECTION {
	short	ncoeff;
	double	*acoeff;
	double	*bcoeff;
	double	*memory;
} FILTER_SECTION;

/* structure of a filter */
typedef struct FILTER {
	short	nsection;
	FILTER_SECTION	*section;
} FILTER;

/* complex data type */
typedef struct {
	double	re,im;
} complex;

#ifdef __cplusplus
extern "C" {
#endif

/* function prototypes */
FILTER * filter_design(
int,			/* filter type */
int,			/* filter order */
double,			/* lower band edge */
double,			/* upper band edge */
double			/* sampling frequency */
);

FILTER * filter_resonator(
double,			/* centre freq */
double,			/* bandwidth */
double			/* sampling frequency */
);

void	filter_free(
FILTER *
);

void	filter_clear(
FILTER *
);

float	filter_sample(
FILTER *,		/* filter */
double			/* sample */
);

double	filter_signal(
FILTER *,		/* filter */
short *,		/* input signal */
short *,		/* output signal */
int			/* # samples */
);

double	filter_response(
FILTER *,		/* filter */
double,			/* response freq */
double			/* sampling freq */
);

#ifdef __cplusplus
}
#endif
