/* digboxtext -- draw proportionally spaced text within region */

#include <stdio.h>
#include <math.h>
#include "SFSCONFG.h"
#include "dig.h"

/* draw vector text in a fixed size box */
#ifdef __STDC__
void   digboxtext(int  bun,float  x,float  y,float  len,float  height,float  ang,char  *txt,int prop)
#else
void	digboxtext(bun,x,y,len,height,ang,txt,prop)
int 	bun;			/* bundle number */
float 	x,y;			/* coordinates of bottom middle of box */
float	len,height;		/* length and height of box */
float	ang;			/* angle of box */
char 	*txt;			/* text */
int 	prop;			/* proportional flag */
#endif
{
	double lenstr;
	double phi,sinphi,cosphi;

	phi = DEG_TO_RADS * ang;
	cosphi = cos(phi);
	sinphi = sin(phi);
	lenstr = digvtextlen(txt,height,0.0,prop);

/* Draw a cross:
    digline(bun,
	x-0.5*(len*cosphi+height*sinphi),y-0.5*(len*sinphi-height*cosphi),
	x+0.5*(len*cosphi-height*sinphi),y+0.5*(len*sinphi+height*cosphi));
    digline(bun,x,y,x-height*sinphi,y+height*cosphi);
*/

	while (lenstr > len) {
		height *= 0.95;
		lenstr = digvtextlen(txt,height,0.0,prop);
	}
	lenstr *= 0.5;
	digvtext(bun,(float)(x-lenstr*cosphi),(float)(y-lenstr*sinphi),txt,(float)height,(float)ang,prop);
	digflush();
}

#ifdef EMO
#include <stdio.h>

main()
{

	digstart('g',NULL,0);
	digscale(2.0,2.0,1);

	digbox(20,1.0,0.1,2.0,0.5);
	digboxtext(20,1.5,0.1,1.0,0.4,0.0,"A",1);
	digboxtext(20,1.5,0.1,1.0,0.4,0.0,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",1);

	digline(20, 0.5-0.1767,0.5+0.1767, 0.5+0.1767,0.5-0.1767);
	digline(20, 0.5+0.1767,0.5-0.1767, 1.5+0.1767,1.5-0.1767);
	digline(20, 1.5+0.1767,1.5-0.1767, 1.5-0.1767,1.5+0.1767);
	digline(20, 1.5-0.1767,1.5+0.1767, 0.5-0.1767,0.5+0.1767);
	digboxtext(20,1.0+0.1767,1.0-0.1767,1.414,0.5,45.0,"A",1);
	digboxtext(20,1.0+0.1767,1.0-0.1767,1.414,0.5,45.0,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",1);

	digbox(20,0.1,1.0,0.5,2.0);
	digboxtext(20,0.5,1.5,1.0,0.4,90.0,"A",1);
	digboxtext(20,0.5,1.5,1.0,0.4,90.0,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",1);
	digquit(15);
}

#endif
