/* diggetmousech -- lowest level access to pointing device and keyboard */

#include <stdio.h>
#include <ctype.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

int	diggetmousech(button,xm,ym)
int	*button;		/* returned mouse button */
float 	*xm,*ym;		/* returned mouse co-ordinates */
{
	int	pxm,pym;	
	int 	ch;

	ch = diggetmousechp(button,&pxm,&pym);

	/* convert to real co-ordinates */
	*xm = (pxm - digdata.xorig) / digdata.xscale;
	*ym = (pym - digdata.yorig) / digdata.yscale;

	return(ch);
}

int	diggetmousechp(button,xm,ym)
int	*button;
int	*xm,*ym;
{
	int	ich=0;
	int	code=0;
	
	/* call mouse routine */
	if (digtable[digdata.select].mouse)
		code=((*digtable[digdata.select].mouse)(button,xm,ym,&ich));

	/* save coordinates and button press */
	digdata.xmouse = *xm;
	digdata.ymouse = *ym;
	digdata.smouse = *button;

	if ((code==0) || (code==DIG_KEY))
		return(ich);
	else
		return(code);
}

#ifdef EMO
main()
{
	char	pr[80];
	float	x,y;
	int	ch,b=0,oldb=0;

	digstart('\0',NULL,1);
	digscale(4.0,4.0,1);
	digorigin(2.0,2.0);
	digbox(23,-0.1,-0.1,0.1,0.1);
	digflush();
	
	diginitmouse(0.0,0.0);

	while ((ch=diggetmousech(&b,&x,&y)) != 'q') {
		if (ch==DIG_REDRAW) {
			digscale(4.0,4.0,1);
			digorigin(2.0,2.0);
			digclearscreen();
			digbox(23,-0.1,-0.1,0.1,0.1);
			digflush();
		}
		else {
			sprintf(pr,"you typed code %04d '%c'",ch,ch);
			if (ch) digprompt(pr);
		}
		if (b != oldb) {
			switch (b) {
			case 0:	digprompt("zero"); break;
			case 1:	digprompt("one"); break;
			case 2:	digprompt("two"); break;
			case 3:	digprompt("three"); break;
			case 4:	digprompt("four"); break;
			case 5:	digprompt("five"); break;
			case 6:	digprompt("six"); break;
			case 7:	digprompt("seven"); break;
			}
			if (b) {
			    digline(20,0.0,0.0,x,y);
			    digflush();
			}
		}
		oldb=b;
	}
	digkillmouse();
	digend();
	exit(0);
}
#endif
