/* winptest -- test use of WIN32 API functions to control printer */

#include <windows.h>
#include <stdio.h>
#include <malloc.h>

void main()
{
	PRINTER_DEFAULTS pd;
	HANDLE 		hPrinter = NULL;
	DOCINFO		DocInfo;
	DWORD 		dwNeeded = 0;
	PRINTER_INFO_2 	*pi2;
	HDC	hDC;

	char	lbuf[256];
	char	*n,*d,*p;

	/* get the name of the printer */
	GetProfileString("windows", "device", ",,,", lbuf, 256);
	n = strtok(lbuf,",");
	d = strtok(NULL,", ");
	p = strtok(NULL,", ");

	/* Open printer handle */
	ZeroMemory(&pd, sizeof(pd));
	pd.DesiredAccess = PRINTER_ACCESS_USE;

	if (!OpenPrinter(n, &hPrinter, &pd)) {
		fprintf(stderr,"Failed to open printer\n");
		exit(1);
	}

	/* get the printer name */
	GetPrinter(hPrinter, 2, 0, 0, &dwNeeded);
	pi2 = (PRINTER_INFO_2 *)calloc(1,dwNeeded);
	if (!GetPrinter(hPrinter, 2, (LPBYTE)pi2, dwNeeded, &dwNeeded)) {
		DWORD err=GetLastError();
		ClosePrinter(hPrinter);
		fprintf(stderr,"GetPrinter(2) fails error=%d dwneeded=%d\n",err,dwNeeded);
		exit(1);
	}
	printf("Found printer '%s'\n",pi2->pPrinterName);
	printf("\tOrientation=%X\n",pi2->pDevMode->dmOrientation);

	pi2->pDevMode->dmFields = DM_ORIENTATION;
	pi2->pDevMode->dmOrientation = DMORIENT_LANDSCAPE;

	/* get a device context */
	if ((hDC = CreateDC(NULL,pi2->pPrinterName,NULL,pi2->pDevMode))==NULL) {
		ClosePrinter(hPrinter);
		fprintf(stderr,"Could not get Device Context\n");
		exit(1);
	}

	/* start a new document */
	DocInfo.cbSize = sizeof(DOCINFO);
	DocInfo.lpszDocName = "Test Document";
	DocInfo.lpszOutput = NULL;
	DocInfo.lpszDatatype = NULL;
	DocInfo.fwType = 0;
	if (StartDoc(hDC,&DocInfo)==SP_ERROR) {
		ClosePrinter(hPrinter);
		fprintf(stderr,"Could not start document\n");
		exit(1);
	}

	/* start a new page */
	if (StartPage(hDC)<=0) {
		ClosePrinter(hPrinter);
		fprintf(stderr,"Could not start page\n");
		exit(1);
	}

	/* draw a line */
	MoveToEx(hDC,100,100,NULL);
	LineTo(hDC,200,200);
	TextOut(hDC,250,250,"Hello, hello, testing.",22);

	/* end the page */
	EndPage(hDC);

	/* end the document */
	EndDoc(hDC);

	/* release device context */
	DeleteDC(hDC);

	/* close the printer */
	ClosePrinter(hPrinter);

	/* that's all folks */
	exit(0);
}
