/* digitemaxis -- x-axis routine for digitem library */

/* version 1.0 - M.A.Huckvale - March 2003 */

#include <stdio.h>
#include <fcntl.h>
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

static struct {
	double	time;		/* units for scale factor */
	double	scale;		/* scale factor */
	char	*label;		/* scale label */
	char	*format;	/* printf format */
} timtab[]=
{
	{ 1000000,	1000000,	"M",	"%.0f" },
	{ 500000,	1000000,	"M",	"%.1f" },
	{ 200000,	1000000,	"M",	"%.1f" },
	{ 100000,	1000000,	"M",	"%.1f" },
	{ 50000,	1000,		"k",	"%.0f" },
	{ 20000,	1000,		"k",	"%.0f" },
	{ 10000,	1000,		"k",	"%.0f" },
	{ 5000,		1000,		"k",	"%.0f" },
	{ 2000,		1000,		"k",	"%.0f" },
	{ 1000,		1000,		"k",	"%.0f" },
	{ 500,		1000,		"k",	"%.1f" },
	{ 200,		1000,		"k",	"%.1f" },
	{ 100,		1,			"",		"%.0f" },
	{ 50,		1,			"",		"%.0f" },
	{ 10.0,		1.0,		"",		"%.0f" },
	{ 5.0,		1.0,		"",		"%.0f" },
	{ 2.0,		1.0,		"",		"%.0f" },
	{ 1.0,		1.0,		"",		"%.0f" },
	{ 0.5,		1.0,		"",		"%.1f" },
	{ 0.2,		1.0,		"",		"%.1f" },
	{ 0.1,		1.0,		"",		"%.1f" },
	{ 0.05,		0.001,		"m",	"%.0f" },
	{ 0.02,		0.001,		"m",	"%.0f" },
	{ 0.01,		0.001,		"m",	"%.0f" },
	{ 0.005,	0.001,		"m",	"%.0f" },
	{ 0.002,	0.001,		"m",	"%.0f" },
	{ 0.001,	0.001,		"m",	"%.0f" },
	{ 0.0005,	0.001,		"m",	"%.1f" },
	{ 0.0002,	0.001,		"m",	"%.1f" },
	{ 0.0001,	0.001,		"m",	"%.1f" },
	{ 0.00005,0.000001,		"u",	"%.0f" },
	{ 0.00002,0.000001,		"u",	"%.0f" },
	{ 0.00001,0.000001,		"u",	"%.0f" },
	{ 0,	0,	"",	"" }
};

/* grid points for external access */
int	digit_xgrid[100];
int	digit_nxgrid;

#ifdef __STDC__
int    digitemaxis(int32  bundles,float  xl,float    yb,float  xr,float  yt,double  start,double  stop,int  flags,char *title,char *units)
#else
int digitemaxis(bundles,xl,yb,xr,yt,start,stop,flags,title,units)
int32	bundles;	/* colours: 10000*divisions + 100*labels + title */
float	xl,yb,xr,yt;	/* x,y co-ords of display */
double	start,stop;	/* start, stop time (seconds) */
int	flags;		/* format flags */
char	*title,*units;
#endif
{
	int	scale,xoff;
	int	ixl,iyb,ixr,iyt,iym,iyl;
	int	tbun,lbun,dbun;
	double	unittime,tenthtime,offset,t,scalex;
	int	x,marks=0;
	char	str[32];

	/* get pixel coordinates of box */
	ixl = xpix(xl);
	iyb = ypix(yb);
	ixr = xpix(xr);
	iyt = ypix(yt);
	if (xr < xl) {
		t = xl;
		xl = xr;
		xr = (float)t;
	}
	if (yt < yb) {
		t = yb;
		yb = yt;
		yt = (float)t;
	}

	if (flags & DIGITEMINVERT) {
		/* calc "iym" - top of small markers */
		iym = iyb + 2*digdata.chheight;
		if (iym > iyt) iym = iyt;
		if (iym < (iyt+iyt+iyt+iyt+iyb)/5) iym = (iyt+iyt+iyt+iyt+iyb)/5;
		/* calc "iyl" - bottom of lettering */
		iyl = (iyt+iyt+iyt+iyb+iyb)/5 - digdata.chheight/2;
		if (iyl < iyb) iyl = iyb;
	}
	else {
		/* calc "iym" - top of small markers */
		iym = iyt - 2*digdata.chheight;
		if (iym < iyb) iym = iyb;
		if (iym > (iyt+iyb+iyb+iyb+iyb)/5) iym = (iyt+iyb+iyb+iyb+iyb)/5;
		/* calc "iyl" - bottom of lettering */
		iyl = (iyt+iyt+iyb+iyb+iyb)/5 - digdata.chheight/2;
		if (iyl < iym) iyl = iym;
	}

	/* determine bundles */
	tbun = bundles % 100;
	if (tbun==0) tbun=DEFBUN;
	lbun = (bundles % 10000) / 100;
	if (lbun==0) lbun=DEFBUN;
	dbun = (bundles % 1000000) / 10000;
	if (dbun==0) dbun=DEFBUN;
	tbun = (bundles % 100000000) / 1000000;
	if (tbun==0) dbun=DEFBUN;

	/* determine size of x-axis offset */
	if (!digdata.setup) return(-1);
	xoff = AXCHAR * digdata.chwidth + 3;

	/* clear box */
	digfillboxp(0,ixl,iyb,ixr,iyt);

	/* draw box if required */
	if (flags & DIGITEMBOX) {
		digboxp(dbun,ixl,iyb,ixr,iyt);
		diglinep(dbun,ixl+xoff,iyb,ixl+xoff,iyt);
	}

	/* determine how many timing markers */
	/* -- go for 1 marker every 12 or so h/w text chars */
	unittime = 12 * digdata.chwidth * (stop - start) / (ixr - ixl - xoff);
	for (scale=0;(timtab[scale].time > 0) && (timtab[scale].time > unittime);scale++) ;
	if (timtab[scale].time==0) return(-1);
	unittime=timtab[scale].time;
	tenthtime=unittime/10;

	/* calculate offset time of scale */
	offset = ((int)(start/unittime))*unittime + unittime - start;
	if (offset>=unittime) offset=0.0;
	marks = 10 - (int)(10*offset/unittime);
	offset = ((int)(start/tenthtime))*tenthtime + tenthtime - start;
	if (offset>=tenthtime) offset=0.0;

	/* display time scale */
	scalex = (double)(ixr - ixl - xoff)/(stop-start);
	stop -= start;
	digit_nxgrid=0;
	for (t = offset; t < stop; t += tenthtime) {
		x = (int)(ixl + xoff + t * scalex);
		if ((marks % 10)==0) {
			diglinep(dbun,x,iyl,x,iyt);
			sprintf(str,timtab[scale].format,(start+t)/timtab[scale].scale);
			if ((int)(x + 3 + digdata.chwidth * strlen(str)) < ixr)
				digtextp(dbun,x+3,iyl,str);
			if (digit_nxgrid < 100) digit_xgrid[digit_nxgrid++]=x;
		}
		else if ((marks % 10)==5) {
			if (flags & DIGITEMINVERT)
				diglinep(dbun,x,iyt,x,(iyl+iyt)/2);
			else
				diglinep(dbun,x,iyb,x,(iyl+iyt)/2);
		}
		else {
			if (flags & DIGITEMINVERT)
				diglinep(dbun,x,iyt,x,iym);
			else
				diglinep(dbun,x,iyb,x,iym);
		}
		marks++;
	}

	/* display units */
	if (!(flags & DIGITEMNOLABEL)) {
		sprintf(str,"%s (%s%s)",title,timtab[scale].label,units);
		x = ixr - strlen(str)*digdata.chwidth;
		if (flags & DIGITEMINVERT) {
			digfillboxp(0,x,iyb+1,ixr,iyb+digdata.chheight+1);
			digtextp(tbun,x,iyb+1,str);
		}
		else {
			digfillboxp(0,x,iyt-digdata.chheight-1,ixr,iyt-1);
			digtextp(tbun,x,iyt-digdata.chheight-1,str);
		}
	}
	digflush();

	return(0);
}

#ifdef EMO
main ()
{

	digstart('\0',NULL,1);
	digscale(100.0,100.0,0);
	digclearscreen();

	digitemaxis(222120,0.0,90.0,100.0,100.0,0.0,10.0,1,"Frequency","Hz");
	digitemaxis(222120,0.0,80.0,100.0,90.0,0.099999,10.0,1|DIGITEMINVERT,"Frequency","Hz");
	digitemaxis(222120,0.0,70.0,100.0,80.0,0.10001,10.0,1,"Frequency","Hz");
	digitemaxis(222120,0.0,60.0,100.0,70.0,1.65,10.2,1|DIGITEMINVERT,"Frequency","Hz");
	digitemaxis(222120,0.0,50.0,100.0,60.0,9.5,10.0,1,"Frequency","Hz");
	digitemaxis(222120,0.0,40.0,100.0,50.0,9.95,10.0,1|DIGITEMINVERT,"Frequency","Hz");
	digitemaxis(222120,0.0,30.0,100.0,40.0,9.995,10.0,1,"Frequency","Hz");
	digitemaxis(222120,0.0,20.0,100.0,30.0,9.9995,10.0,1|DIGITEMINVERT,"Frequency","Hz");
	digitemaxis(222120,0.0,13.0,100.0,20.0,0.0,10.0,1,"Frequency","Hz");
	digitemaxis(222120,0.0,8.0,100.0,13.0,0.0,10.0,1|DIGITEMINVERT,"Frequency","Hz");
	digitemaxis(222120,0.0,5.0,100.0,8.0,0.0,10.0,1,"Frequency","Hz");
	digitemaxis(222120,0.0,0.0,50.0,5.0,0.0,10.0,1|DIGITEMINVERT,"Frequency","Hz");
	digitemaxis(222120,50.0,0.0,80.0,5.0,0.0,10.0,1,"Frequency","Hz");
	digitemaxis(222120,80.0,0.0,100.0,5.0,0.0,10.0,1,"Frequency","Hz");

	digquit(1);
}
#endif
