/* digitfreq -- y-axis display for digitem library */

/* version 1.0 - M.A.Huckvale - November 1987 */

/* version 2.0 - August 2012
	- added log scale
*/

#include <stdio.h>
#include <fcntl.h>
#include <math.h>
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

static struct {
	double	unit;		/* units for scale factor */
	double	scale;		/* scale factor */
	char	*label;		/* scale label */
	char	*format;	/* printf format */
	char	*format5;	/* printf format for fifth */
} unitab[]=
{
	{ 5000000000.0,1000000000.0,"G",	"%.0f","%.1f" },
	{ 2000000000.0,1000000000.0,"G",	"%.0f","%.0f" },
	{ 1000000000.0,1000000000.0,"G",	"%.0f","%.1f" },
	{ 500000000.0, 1000000000.0,"G",	"%.1f","%.2f" },
	{ 200000000.0, 1000000000.0,"G",	"%.1f","%.1f" },
	{ 100000000.0, 1000000000.0,"G",	"%.1f","%.2f" },
	{ 50000000.0,  1000000.0,	"M",	"%.0f","%.0f" },
	{ 20000000.0,  1000000.0,	"M",	"%.0f","%.0f" },
	{ 10000000.0,  1000000.0,	"M",	"%.0f","%.0f" },
	{ 5000000.0,   1000000.0,	"M",	"%.0f","%.1f" },
	{ 2000000.0,   1000000.0,	"M",	"%.0f","%.0f" },
	{ 1000000.0,   1000000.0,	"M",	"%.0f","%.1f" },
	{ 500000.0,    1000000.0,	"M",	"%.1f","%.2f" },
	{ 200000.0,    1000000.0,	"M",	"%.1f","%.1f" },
	{ 100000.0,    1000000.0,	"M",	"%.1f","%.2f" },
	{ 50000.0,     1000.0,		"k",	"%.0f","%.0f" },
	{ 20000.0,     1000.0,		"k",	"%.0f","%.0f" },
	{ 10000.0,     1000.0,		"k",	"%.0f","%.0f" },
	{ 5000.0,	   1000.0,		"k",	"%.0f","%.1f" },
	{ 2000.0,	1.0,    "",		"%.0f","%.0f" },
	{ 1000.0,	1.0,    "",		"%.0f","%.1f" },
	{ 500.0,	1.0,    "",		"%.0f","%.0f" },
	{ 200.0,	1.0,    "",		"%.0f","%.0f" },
	{ 100.0,	1.0,    "",		"%.0f","%.0f" },
	{ 50.0,		1.0,	"",		"%.0f","%.0f" },
	{ 20.0,		1.0,	"",		"%.0f","%.0f" },
	{ 10.0,		1.0,	"",		"%.0f","%.0f" },
	{ 5.0,		1.0,	"",		"%.0f","%.1f" },
	{ 2.0,		1.0,	"",		"%.0f","%.0f" },
	{ 1.0,		1.0,	"",		"%.0f","%.1f" },
	{ 0.5,		1.0,	"",		"%.1f","%.2f" },
	{ 0.2,		1.0,	"",		"%.1f","%.1f" },
	{ 0.1,		1.0,	"",		"%.1f","%.2f" },
	{ 0.05,		0.001,	"m",	"%.0f","%.0f" },
	{ 0.02,		0.001,	"m",	"%.0f","%.0f" },
	{ 0.01,		0.001,	"m",	"%.0f","%.0f" },
	{ 0.005,	0.001,	"m",	"%.0f","%.1f" },
	{ 0.002,	0.001,	"m",	"%.0f","%.0f" },
	{ 0.001,	0.001,	"m",	"%.0f","%.1f" },
	{ 0.0005,	0.001,	"m",	"%.1f","%.2f" },
	{ 0.0002,	0.001,	"m",	"%.1f","%.1f" },
	{ 0.0001,	0.001,	"m",	"%.1f","%.2f" },
	{ 0.00005,	0.000001,"u",	"%.0f","%.0f" },
	{ 0.00002,	0.000001,"u",	"%.0f","%.0f" },
	{ 0.00001,	0.000001,"u",	"%.0f","%.0f" },
	{ 0.000005,	0.000001,"u",	"%.1f","%.1f" },
	{ 0.000002,	0.000001,"u",	"%.1f","%.1f" },
	{ 0.000001,	0.000001,"u",	"%.1f","%.1f" },
	{ 0.0,		0.000001,"u",	"%.2f","%.2f" },
};

/* grid points for external access */
int	digit_ygrid[100];
int	digit_nygrid;

int digitemfreq(int32 bundles,int iyb,int iyt,double start,double stop,int flags)
/* int32	bundles;	/* colours: 10000*divisions + 100*labels + title */
/* int	iyb,iyt;	/* pixel y values */
/* double	start,stop;	/* start, stop value  */
/* int	flags;		/* format flags */
{
	int	scale;
	int	ixm1,ixm2,ixm3;
	double	unitval=1,tenthval=0,offset=0,t,scaley;
	double	val,xs;
	int	x,y,marks=0,fifths=0;
	char	str[32];
	float	digtextlen();

	/* calc "ixm1" - left of small markers */
	ixm1 = digitab.ixl + digitab.ixoff - digdata.chwidth/2;
	/* calc "ixm2" - left of medium markers */
	ixm2 = digitab.ixl + digitab.ixoff - digdata.chwidth;
	/* calc "ixm3" - left of large markers */
	ixm3 = digitab.ixl + digitab.ixoff - digdata.chwidth*3/2;

	if (flags & DIGITEMLOG) {
		if (start < 1.0E-6) start=1.0E-6;
		start=log10(start);
		stop=log10(stop);
		/* determine how many timing markers */
		/* -- go for 1 marker every 4 or so h/w text chars */
		unitval = 4 * digdata.chheight * (stop - start) / (iyt-iyb);
//		fprintf(stderr,"raw unitval=%g\n",unitval);
		tenthval=0;
		if (unitval > 1)
			unitval=1;		/* at least one marker per decade */
		else if (unitval > 0.7)
			unitval=0.5;
		else if (unitval > 0.5) {
			unitval=0.5;
			tenthval=1;
		}
		else if (unitval > 0.2) {
			unitval = 0.2;
			tenthval=1;
		}
		else {
			unitval=0.1;
		}
		/* calculate offset of first marker on scale */
		val=(int)start;
		if (start < 0) val--;
		offset=start-val;
//		fprintf(stderr,"raw start=%g val=%g offset=%g\n",start,val,offset);
		if (offset > log10(5.0))
			offset=1.0+val;
		else if (offset > log(2.0))
			offset=log10(5.0)+val;
		else if (offset > 0.01)
			offset=log10(2.0)+val;
		else
			offset=val;

//		fprintf(stderr,"unitval=%g tenthval=%g offset=%g\n",unitval,tenthval,offset);

		/* display freq scale */
		scaley = (double)(iyt - iyb)/(stop-start);
		digit_nygrid=0;

		if (tenthval) {
			for (t = offset; t < stop; ) {
//				fprintf(stderr,"t=%g\n",t);
				y = (int)(iyb + (t-start) * scaley);

				val=(int)t;
				if (t < 0) val--;
				xs = t-val;
				if (xs==log10(1.5))
					diglinep(digitab.dbun,ixm2,y,digitab.ixl+digitab.ixoff,y);
				else
					diglinep(digitab.dbun,ixm1,y,digitab.ixl+digitab.ixoff,y);

				if (xs > log10(9.5))
					t=log10(20)+val;
				else if (xs > log10(8.5))
					t=1+val;
				else if (xs > log10(7.5))
					t=log10(9.0)+val;
				else if (xs > log10(6.5))
					t=log10(8.0)+val;
				else if (xs > log10(5.5))
					t=log10(7.0)+val;
				else if (xs > log10(4.5))
					t=log10(6.0)+val;
				else if (xs > log10(3.5))
					t=log10(5.0)+val;
				else if (xs > log10(2.5))
					t=log10(4.0)+val;
				else if (xs > log10(1.5))
					t=log10(3.0)+val;
				else if (xs > log10(1.25))
					t=log10(2.0)+val;
				else
					t=log10(1.5)+val;
			}
		}

		for (t = offset; t < stop; ) {

			y = (int)(iyb + (t-start) * scaley);

			diglinep(digitab.dbun,ixm3,y,digitab.ixl+digitab.ixoff,y);

			val=pow(10.0,t);
			sprintf(str,"%g",val);
			if (((y + digdata.chheight/2) <= digitab.iyt) &&
				((y - digdata.chheight/2) >= digitab.iyb)) {
				x = (int)(ixm3 - digtextlenp(str));
				digtextp(digitab.dbun,x-3,y-digdata.chheight/2,str);
			}
			if (digit_nygrid < 100)
				digit_ygrid[digit_nygrid++]=y;

			val=(int)t;
			if (t < 0) val--;
			xs = t-val;
			if (unitval==1)
				t = 1 + val;
			else if (unitval==0.5) {
				if (xs>log10(4.0))
					t=1+val;
				else
					t=log10(5.0)+val;
			}
			else if (unitval==0.2) {
				if (xs > log10(4.0))
					t=1+val;
				else if (xs > log10(1.5))
					t=log10(5.0)+val;
				else
					t=log10(2.0)+val;
			}
			else {
				if (xs > log10(9.5))
					t=log10(20.0)+val;
				else if (xs > log10(8.5))
					t=1+val;
				else if (xs > log10(7.5))
					t=log10(9.0)+val;
				else if (xs > log10(6.5))
					t=log10(8.0)+val;
				else if (xs > log10(5.5))
					t=log10(7.0)+val;
				else if (xs > log10(4.5))
					t=log10(6.0)+val;
				else if (xs > log10(3.5))
					t=log10(5.0)+val;
				else if (xs > log10(2.5))
					t=log10(4.0)+val;
				else if (xs > log10(1.5))
					t=log10(3.0)+val;
				else
					t=log10(2.0)+val;
			}
		}
	}
	else {
		/* determine how many timing markers */
		/* -- go for 1 marker every 4 or so h/w text chars */
		unitval = 4 * digdata.chheight * (stop - start) / (iyt-iyb);
		for (scale=0;(unitab[scale].unit > 0) && (unitab[scale].unit > unitval);scale++) ;
		if (unitab[scale].unit==0) return(-1);
		if (((stop-start)/unitab[scale].unit) < 3) fifths++;
		unitval=unitab[scale].unit;
		tenthval=unitval/10;

		/* calculate offset time of scale */
		if (start < 0)
			offset = ((int)(start/unitval))*unitval - unitval - start;
		else
			offset = ((int)(start/unitval))*unitval + unitval - start;
		if ((offset>=unitval)||(offset<=-unitval)) offset=0.0;
		marks = 10 - (int)(10*offset/unitval);
		if (start < 0)
			offset = ((int)(start/tenthval))*tenthval - tenthval - start;
		else
			offset = ((int)(start/tenthval))*tenthval + tenthval - start;
		if ((offset>=tenthval)||(offset<=-tenthval)) offset=0.0;

		/* display freq scale */
		scaley = (double)(iyt - iyb)/(stop-start);
		stop -= start;
		digit_nygrid=0;
		for (t = offset; t < stop; t += tenthval) {
			y = (int)(iyb + t * scaley);
			if ((y < iyb) || (y > iyt))
				/* skip */;
			else if ((marks % 10)==0) {
				diglinep(digitab.dbun,ixm3,y,digitab.ixl+digitab.ixoff,y);
				if (fifths)
					sprintf(str,unitab[scale].format5,(start+t)/unitab[scale].scale);
				else
					sprintf(str,unitab[scale].format,(start+t)/unitab[scale].scale);
				strcat(str,unitab[scale].label);
				if (((y + digdata.chheight/2) <= digitab.iyt) &&
					((y - digdata.chheight/2) >= digitab.iyb)) {
					x = (int)(ixm3 - digtextlenp(str));
					digtextp(digitab.dbun,x-3,y-digdata.chheight/2,str);
				}
				if (digit_nygrid < 100)
					digit_ygrid[digit_nygrid++]=y;
			}
			else if ((marks % 10)==5) {
				diglinep(digitab.dbun,ixm2,y,digitab.ixl+digitab.ixoff,y);
				if (fifths) {
					sprintf(str,unitab[scale].format5,(start+t)/unitab[scale].scale);
					strcat(str,unitab[scale].label);
					if (((y + digdata.chheight/2) <= digitab.iyt) &&
						((y - digdata.chheight/2) >= digitab.iyb)) {
						x = (int)(ixm3 - digtextlenp(str));
						digtextp(digitab.dbun,x-3,y-digdata.chheight/2,str);
					}
				}
				if (digit_nygrid < 100)
					digit_ygrid[digit_nygrid++]=y;
			}
			else if (tenthval*scaley >= digdata.chheight/4.0)
				diglinep(digitab.dbun,ixm1,y,digitab.ixl+digitab.ixoff,y);
			marks++;
		}
	}

	return(0);
}

#ifdef EMO
digitfreq(int bundles,float xl,float yb,float xr,float yt,double start,double stop,int flags)
{
	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);

	/* draw freq axis */
	digitemfreq(bundles,digitab.iyb,digitab.iyt,start,stop,flags);
}

main ()
{

	digstart('\0',NULL,1);
	digscale(100.0,100.0,0);
	digclearscreen();

	digitfreq(222120,  0.0,  0.0, 20.0, 100.0,     50.0,  6400.0, DIGITEMLOG);
	digitfreq(222120, 20.0,  0.0, 40.0, 100.0,      5.0, 20000.0, DIGITEMLOG);
	digitfreq(222120, 40.0,  0.0, 60.0,  40.0,      5.0, 20000.0, DIGITEMLOG);
	digitfreq(222120, 60.0,  0.0, 80.0, 100.0,      0.01,     9.5, DIGITEMLOG);

/*
	digitfreq(222120, 20.0,  0.0, 40.0,  90.0,  -1000.0, 1000.00, 1);
	digitfreq(222120, 40.0,  0.0, 60.0,  80.0, -0.00045,  0.0001, 1);
	digitfreq(222120, 60.0,  0.0, 80.0,  70.0,     1.65,    10.2, 1);
*/
	digitfreq(222120, 80.0, 10.0,100.0,  60.0,      9.5,    10.0, 1);
	digitfreq(222120, 80.0, 60.0,100.0,  80.0,      0.0,     2.0, 1);

	digquit(1);
}
#endif
