/*  digitemPC ---- LPC coefficients display  */

/* version 1.0 - November 2006 */

#include <stdio.h>
#include <fcntl.h>
#include <math.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"
#include "digitem.h"
#include "fft.h"

#define MAXFFT		4096
#define MAXPIXELS	2048
#define DBRANGE		50.0
#define DBHEADROOM	6.0

extern int	digit_ygrid[100];
extern int	digit_nygrid;
extern int	digit_xgrid[100];
extern int	digit_nxgrid;

#ifdef __STDC__
int    digitemPC(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct pc_rec *buff,double    start,double   stop,int  flags)
#else
int digitemPC(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;	/* colours for graph */
float		xl,yb,xr,yt;	/* co-ords of box */
struct item_header *item;	/* data definition */
struct pc_rec	*buff;		/* data buffer */
double		start,stop;     /* start and stop times	*/
int	 	flags;		/* possible options on display */
#endif
{
	register  int   i,j;	/* index variable */
	int		ncoeff;
	int		x,y;
	double		s,t;
	static	char	*symbol[9]={"1","2","3","4","5","6","7","8","9"};
	int		*lasty,lastx,xnext;

	float	fftbuf[MAXFFT+20];
	unsigned char	pixels[MAXPIXELS];
	double		xstep,xend,xpos,xsum,xmax;
	int		ixstart,ixend;
	double		dbnorm=30,edb;
	int		p,plast;
	int		lo,hi;
	int		pheight,pwidth,cnt;
	int		fftsize;
	float		*xp,gain;
	char		messg[128];

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;

	/* write axis label */
	y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
	digtextp(digitab.lbun,digitab.ixl+3,digitab.iytitle,"Hz");

	/* calculate y scaling */
	digitab.scaley = (0.5/item->frameduration)/(digitab.iyt-digitab.iyb);

	/* plot y-axis */
	if (!(flags & DIGITEMFIX)) {
		digitab.lo = 0.0;
		digitab.hi = 0.5/item->frameduration;
	}
	digitemfreq(bundles,digitab.iyb,digitab.iyt,digitab.lo,digitab.hi,1);

	/* draw grid, if required */
	if (flags & DIGITEMYGRID) {
		for (i=0;i<digit_nygrid;i++)
			diglinep(81,digitab.ixl+digitab.ixoff,digit_ygrid[i],digitab.ixr,digit_ygrid[i]);
	}
	if (flags & DIGITEMXGRID) {
		for (i=0;i<digit_nxgrid;i++)
			diglinep(81,digit_xgrid[i],digitab.iyb,digit_xgrid[i],digitab.iyt);
	}

	/* index data and plot tx marks */
	s = item->offset-start;
	ncoeff=SFSRECSIZE(item);

	if (strstr(item->params,"format=LSP")) {

		lasty = (int *)calloc(ncoeff,sizeof(int));
		lastx = -1;

		for (i=0;i<item->numframes;i++) {

			/* find time of frame */
			t = buff[i].posn*item->frameduration+s;

			/* calculate x-value for display */
			x = (int)(digitab.ixl + digitab.ixoff + t*digitab.scalex*digdata.xscale);

			/* end at last tx plottable */
			if (x > digitab.ixr-digdata.chwidth) break;

			/* check x-value lies within box */
			if ((x >= (digitab.ixl+digitab.ixoff)) && (x < digitab.ixr)) {
				/* plot frequency data */
				for (j=0;j<ncoeff;j++) {
					y = (int)(digitab.iyb + (buff[i].data[j]/item->frameduration)/digitab.scaley);
					if ((y > digitab.iyb) && (y <= digitab.iyt)) {
						if (lasty[j]!=0) diglinep(digitab.gbun,lastx,lasty[j],x,y);
					}
					lasty[j]=y;
				}
			}
			lastx=x;
		}

		free(lasty);
	}
	else {

		/* get display size */
		ixstart = xpix(xl) + 1;
		ixend = xpix(xr);
		pheight = (digitab.iyt - digitab.iyb)/digdata.digdev.greypixheight;
		if (pheight > MAXPIXELS) pheight = MAXPIXELS;
		pwidth = (ixend - ixstart - 1)/digdata.digdev.greypixwidth;

		/* get window size - speech chunk */
		fftsize = (int)(2 * (pheight+1));
		if (fftsize < 128)
			fftsize = 128;
		else if (fftsize < 256)
			fftsize = 256;
		else if (fftsize < 512)
			fftsize = 512;
		else if (fftsize < 1024)
			fftsize = 1024;
		else if (fftsize < 2048)
			fftsize = 2048;
		else
			fftsize = 4096;

//error("yt=%d yb=%d pheight=%d fft=%d pw=%d ph=%d",digitab.iyt,digitab.iyb,pheight,fftsize,digdata.digdev.greypixwidth,digdata.digdev.greypixheight);

		/* get normalising factor from largest gain */
		gain=0;
		for (i=0;i<item->numframes;i++)
			if (buff[i].gain > gain) gain=buff[i].gain;
		if (gain > 0)
			dbnorm = 25+20*log10(gain)-50;
		else
			dbnorm = -30;

		/* run through data buffer, plotting where required */
		hi = -1000; lo = 1000;

		for (i=0;i<item->numframes;i++) {

			/* find time of frame */
			t = buff[i].posn*item->frameduration+s;

			/* calculate x-value for display */
			x = (int)(digitab.ixl + digitab.ixoff + t*digitab.scalex*digdata.xscale);

			/* end at last tx plottable */
			if (x > digitab.ixr-digdata.chwidth) break;

			/* check x-value lies within box */
			if ((x >= (digitab.ixl+digitab.ixoff)) && (x < digitab.ixr)) {

				/* get next start x */
				if (i < item->numframes-1)
					t = buff[i+1].posn*item->frameduration+s;
				else
					t = (buff[i].posn+buff[i].size)*item->frameduration+s;
				xnext = (int)(digitab.ixl + digitab.ixoff + t*digitab.scalex*digdata.xscale);
				if (xnext >= digitab.ixr) xnext=digitab.ixr-1;

				/* calculate LPC spectrum */
				fftbuf[0]=1.0;
				for (j=1;j<=ncoeff;j++) fftbuf[j] = buff[i].data[j-1];
				for (;j<fftsize;j++) fftbuf[j]=0;
				if (buff[i].gain>0)
					gain = (float)(20*log10(buff[i].gain));
				else
					gain = 0;

				/* perform FFT */
				REALFFT(fftbuf, fftsize/2, 1);

				/* calculate pixel values */
				memset(pixels,0,pheight);
				xstep = (float)((fftsize-2)/pheight);
				xend = xstep;
				xpos = 0.0;
				xp = fftbuf+2;
				plast = 0;

				for (j=pheight-1;j>=0;j--) {
					xsum = 0.01;
					cnt = 0;
					while (xpos < xend) {
						xsum += *xp * *xp;
						xp++;
						xsum += *xp * *xp;
						xp++;
						xpos += 2.0;
						cnt++;
					}
					if (cnt > 0) {
						edb = gain + 10.0 * log10(cnt/xsum);
						if (edb > hi) hi = (int)edb;
						if (edb < lo) lo = (int)edb;
						p = (int)(0.5+(float)digdata.digdev.greylevels*(edb - dbnorm)/DBRANGE);
					}
					else
						p = plast;
					if (p >= digdata.digdev.greylevels)
						p = digdata.digdev.greylevels-1;
					else if (p < 0)
						p = 0;
					pixels[j] = p;
					xend += xstep;
					plast=p;
				}

				/* call device driver greyscale routine */
				for (;x<xnext;x+=digdata.digdev.greypixwidth)
					(*digtable[digdata.select].greyscale)(x,digitab.iyb,pheight,pixels);
			}
			lastx=x;
		}
	}

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef	EMO
char	*progname="digitemPC";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct		item_header item;          /* data definition */
	struct pc_rec	*buff;                     /* data buffer     */

	/* choose between laser printer or terminal, 'k' indicates   */
	/* the laser printer, '\0' indicates a terminal.                */

	if (strcmp(argv[1],"-p") ==0) {
		digstart ('k',NULL,1);
	  	getitem(argv[2],PC_TYPE,"*",&item,&buff);
	}
	else {
		digstart ('\0',NULL,1);
		getitem(argv[1],PC_TYPE,"*",&item,&buff);
	}

	/* set the scale */
	digscale (10.0,10.0,0);

	/* clear the screen for the display */
	digclearscreen();

	/* call digitemtime for the timescale */
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,1.0,1);

	/* call digitemPC for the PC data */
	digitemPC(20,0.0,6.0,10.0,9.0,&item,buff,0.0,1.0,1);

	digitemPC(20,0.0,3.0,10.0,6.0,&item,buff,0.5,1.5,3);

	item.offset=0.1;
	digitemPC(20,0.0,0.0,10.0,3.0,&item,buff,0.0,1.0,3);

	digquit(1);
	exit(0);
}
#endif


