/* digitemSP -- speech and lx display */

/* version 1.0 - M.A. Huckvale - July 1987 */
/* version 1.1 - November 1987
	- release of SFS digitem routines
*/
#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

#ifdef __STDC__
int    digitemSP(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,short  *buff,double  start,double  stop,int  flags)
#else
int digitemSP(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;
float		xl,yb,xr,yt;
struct item_header *item;
short		*buff;
double		start,stop;
int		flags;
#endif
{
	register int	i,hi,lo;
	register short	*s;
	int	x,y;
	int	numf,bstart;
	char	str[32];
	float	digtextlen();

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;
	yt = yval(digitab.iyt);

	/* write axis label */
	y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
	/* digtextp(digitab.lbun,digitab.ixl+3,digitab.iytitle,"Amp"); */

	/* check timing of data set */
	bstart = (int)((start-item->offset)/item->frameduration);
	numf = (int)(1+(stop - start)/item->frameduration);
	if ((bstart+numf) > item->numframes) {
		/* data does not reach to right end */
		xr = (float)(xl + (item->numframes-bstart)*item->frameduration*digitab.scalex);
		numf = item->numframes - bstart;
	}
	if (bstart < 0) {
		/* data does not reach to left end */
		xl += (float)((-bstart*item->frameduration)*digitab.scalex);
		numf += bstart;
		bstart=0;
	}

	/* display, if anything left */
	if ((numf>1) && (bstart<item->numframes)) {

		/* get max and min values */
		if (!(flags & DIGITEMFIX)) {
			s = &buff[bstart];
			lo = *s;
			hi = lo;
			for (i=0;i<numf;i++,s++) {
				if (*s < lo) lo = *s;
				if (*s > hi) hi = *s;
			}
			if (hi==lo) { hi=lo+1; lo=hi-2; }
			digitab.hi=hi;
			digitab.lo=lo;
		}

		/* calculate zero point */
		y = (int)(digitab.iyb + ((digitab.iyt-digitab.iyb)*(0-digitab.lo))/(digitab.hi-digitab.lo));
		if ((y > digitab.iyb) && (y < digitab.iyt))
			diglinep(digitab.dbun,digitab.ixl+digitab.ixoff-digdata.chwidth,y,digitab.ixl+digitab.ixoff,y);
		if (flags & DIGITEMYGRID)
			diglinep(81,digitab.ixl+digitab.ixoff,y,digitab.ixr,y);

		/* write values */
		sprintf(str,"%d ",(int)(digitab.hi));
		x = (int)(digitab.ixl+digitab.ixoff-digtextlenp(str));
		digtextp(digitab.dbun,x,digitab.iyt-digdata.chheight-3,str);
		sprintf(str,"%d ",(int)(digitab.lo));
		x = (int)(digitab.ixl+digitab.ixoff-digtextlenp(str));
		digtextp(digitab.dbun,x,digitab.iyb+3,str);


		/* draw graph */
		digwave(digitab.gbun,xl,yb+1/digdata.yscale,xr,yt-1/digdata.yscale,&buff[bstart],numf,(int)(digitab.hi),(int)(digitab.lo));

	}

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef EMO
char	*progname="digitemSP";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct	item_header item;
	short	*buff;
	double	totime;

	if (strcmp(argv[1],"-p")==0) {
		digstart('k',NULL,1);
		getitem(argv[2],SP_TYPE,"*",&item,&buff);
	}
	else {
		digstart('\0',NULL,1);
		getitem(argv[1],SP_TYPE,"*",&item,&buff);
	}

	digscale(10.0,10.0,0);
	digclearscreen();

	totime = item.numframes*item.frameduration;
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,totime,1);
	digitemSP(20,0.0,7.0,10.0,9.0,&item,buff,0.0,totime,3);

	digitemtime(23,0.0,6.0,10.0,6.5,totime-0.25,totime+0.25,1);
	digitemSP(20,0.0,4.0,10.0,6.0,&item,buff,totime-0.25,totime+0.25,3);

	digitemtime(23,0.0,3.0,10.0,3.5,0.0,0.1,1);
	item.offset=0.05;
	digitab.hi=1000;
	digitab.lo = -1000;
	digitemSP(20,0.0,1.0,10.0,3.0,&item,buff,0.0,0.1,7);

	digend();
	exit(0);
}
#endif
