/* DSP routines from Mike Brookes, Imperial College London */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "libic.h"

#define NAME "fftci"

void fftci(data,spect,len)
COMPLEX *data,*spect;
int len;
/*
	Complex inverse fourier transform with len = 2**m

	data[len] <-- spect[n]

        data and spect can be the same array if desired
*/
{
    REAL *pdata,*pdatan,*pspect;
    REAL mrlen,rlen;
    int m;

/* First copy into destination array conjugating */

    pdata = (REAL *) data;
    pspect = (REAL *) spect;
    pdatan = (REAL *) &(data[len]);
    rlen = 1.0/len;
    mrlen = -rlen;
    while(pdata < pdatan) {
	*pdata++ = rlen * *pspect++;
	*pdata++ = mrlen * *pspect++;
	}

/* Now do the transform */

    m = log2ch(len);
    cfdift(data,len,m);
    cbitrev(data,len);

/* Now take complex conjugate */

    pdata = ( (REAL *) data ) - 1;
    while((pdata += 2) < pdatan) {
	*pdata = - *pdata;
	}

    return;
    }
#ifdef EMO

#include <stdio.h>
#include <math.h>
#define LEN 32

main ()
{
    COMPLEX error,data[LEN],data2[LEN],spect[LEN];
    REAL sum,theta;
    int i;

    printf("Test for fftci: (1.0,1.1) + 2 [f] + 3j [3f]\n");
    for (i=0; i<LEN; i++) {
	theta = (TWOPI * i) / LEN;
	data[i].r = 1.0 + 2.0*cos(theta) - 3.0*sin(3.0*theta);
	data[i].i = 1.1 + 2.0*sin(theta) + 3.0*cos(3.0*theta);
	}

    for (i=0; i<LEN; i++) data[i].i = -data[i].i;

    fftci(spect,data,LEN);

    for (i=0; i<LEN; i++) spect[i].i = -spect[i].i;

    for (i=0; i<LEN; i++) {
	if ((spect[i].r*spect[i].r + spect[i].i*spect[i].i) > 0.01) {
	    printf("%3d %8.2f %8.2f\n",i,spect[i].r,spect[i].i);
	    }
	spect[i].r *= LEN;
	spect[i].i *= LEN;
	}


    fftci(data2,spect,LEN);

    sum = 0.0;
    for (i=0; i<LEN; i++) {

	error.r = data2[i].r - data[i].r;
	error.i = data2[i].i + data[i].i;
	sum = sum + error.r * error.r + error.i * error.i;
	}
    printf("\nTotal square error after forward + inverse = %8g\n",sum);
    }
#endif
