/* DSP routines from Mike Brookes, Imperial College London */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "libic.h"

void rbitrev(data,len)
REAL *data;
int len;
{
/*
Float array bit reversal reordering routine

len = 2**m
*/
    REAL temp;
    int i,n1,n2;
    register int j,k;

    n1 = len-1;
    j = n2 = len >> 1;
    for (i=1; i<n1; i++) {
	if (i<j) {
	    temp = data[j];
	    data[j] = data[i];
	    data[i] = temp;
	    }
	k = n2;
	while (k <= j) {
	    j -= k;
	    k = k >> 1;
	    }
	j += k;
	}
    }

#ifdef EMO

#define LEN 32

main()
{
    REAL data[LEN];
    int i;

    for (i=0; i<LEN; i++) {
	data[i] = i;
	}
    rbitrev(data,LEN);
    for (i=0; i<LEN; i++) {
	printf("%5d %6.0f\n",i,data[i]);
	}
    }
#endif
