/* real-to-complex & complex-to-real FFT */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "libic.h"

#define NAME "rfft"

void rfft(data,spect,len)
REAL	*data;
COMPLEX *spect;
int len;
/*
	Real to Complex fourier transform with len = 2**m

	data[len] -> spect[len]
*/
{
    REAL *pdata,*pdatan,*pspect;
    int m;

/* First copy into destination array */

    pdata = (REAL *) data;
    pspect = (REAL *) spect;
    pdatan = (REAL *) &(data[len]);
    while (pdata < pdatan) {
	*pspect++ =  *pdata++;
	*pspect++ = 0.0;
    }

/* Now do the transform */

    m = log2ch(len);
    cfdift(spect,len,m);
    cbitrev(spect,len);

    return;
}

void irfft(data,spect,len)
REAL	*data;
COMPLEX *spect;
int len;
/*
	Complex to real inverse fourier transform with len = 2**m

	data[len] <-- spect[len]

*/
{
	static COMPLEX *temp;
	static int tlen=0;
    REAL *pdata,*pdatan,*pspect;
    REAL mrlen,rlen;
    int m;

	if (len > tlen) {
		if (tlen) free(temp);
		temp = (COMPLEX *)malloc(len*sizeof(COMPLEX));
		tlen=len;
	}

/* First copy into temp array conjugating */

    pdata = (REAL *) temp;
    pspect = (REAL *) spect;
    pdatan = (REAL *) &(temp[len]);
    rlen = 1.0/len;
    mrlen = -rlen;
    while(pdata < pdatan) {
	*pdata++ = rlen * *pspect++;
	*pdata++ = mrlen * *pspect++;
	}

/* Now do the transform */

    m = log2ch(len);
    cfdift(temp,len,m);
    cbitrev(temp,len);

/* Now copy out real result */

    pdata = (REAL *) data;
    pspect = (REAL *) temp;
    pdatan = (REAL *) &(data[len]);
    while (pdata < pdatan) {
	*pdata++ = *pspect++;
	pspect++;
	}

    return;
}


#ifdef EMO

#include <stdio.h>
#include <math.h>
#define LEN 32

main ()
{
	REAL	data[LEN],data2[LEN];
    COMPLEX spect[LEN];
    REAL error,sum,theta;
    int i;

    printf("Test for rfft: 1.0 + 2 [f] + 3 [3f]\n");
    for (i=0; i<LEN; i++) {
	theta = (2*PI * i) / LEN;
	data[i] = 1.0 + 2.0*cos(theta) + 3.0*sin(3.0*theta);
	}

	printf("data="); for (i=0;i<LEN;i++) printf("%g,",data[i]); printf("\n");

    rfft(data,spect,LEN);

    for (i=0; i<LEN; i++) {
	if ((spect[i].r*spect[i].r + spect[i].i*spect[i].i) > 0.01) {
	    printf("%3d %8.2f %8.2f\n",i,spect[i].r/LEN,spect[i].i/LEN);
	    }
	}

    irfft(data2,spect,LEN);

    	printf("data="); for (i=0;i<LEN;i++) printf("%g,",data2[i]); printf("\n");

    sum = 0.0;
    for (i=0; i<LEN; i++) {

	error = data2[i] - data[i];
	sum = sum + error * error;
	}
    printf("\nTotal square error after forward + inverse = %8g\n",sum);
    }
#endif
