/* netread - network version of read call */

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "sfs.h"

/* check if only "stub" routine required */
#ifndef NETWORK

/* network read replacement routine */
int32 netread(node,filename,offset,buff,length)
char	*node;
char	*filename;
int32	offset;
char	*buff;
int32	length;
{
	return(0L);
}

#else

#include "sfsnet.h"

/* global data */
static struct sockaddr_in sinhim = { AF_INET };
extern int errno;
struct reqrec request;

/* network file read */
int32 netread(node,filename,offset,buff,length)
char	*node;
char	*filename;
int32	offset;
char	*buff;
int32	length;
{
	/* processing variable */
	int		rlen;			/* request length */
	short		status;			/* request status */
	short		mode;			/* file mode */
	int		fd;			/* socket descriptor */
	int		ofd;			/* output file descriptor */
	struct hostent 	*hp;			/* host name pointer */
	int32		i,count;
	char		*p;

	/* get node address */
	hp = gethostbyname(node);
	if (!hp)
		error("'%s' host not found",node);

	/* get a socket */
	bcopy(hp->h_addr, &sinhim.sin_addr, sizeof(sinhim.sin_addr));
	sinhim.sin_port = htons(PORTNUM);
	if ((fd=socket(AF_INET, SOCK_STREAM, 0)) < 0)
		error("unable to open socket",NULL);

	/* make connection */
	if (connect(fd,&sinhim,sizeof(sinhim)) < 0)
		error("unable to connect socket to '%s'",node);

	/* send request */
	request.reqid = htons(READDATA);
	request.start = htonl(offset);
	request.length= htonl(length);
	strcpy(request.buff,filename);
	rlen = sizeof(request)-sizeof(request.buff)+strlen(request.buff)+1;
	if (write(fd,&request,rlen) != rlen)
		error("write error on connection to '%s'",node);

	/* get data back */
	count=0;
	while (((rlen=read(fd,&request,sizeof(request))) > 0) && ((status=(short)ntohs(request.status)) == 0)) {
		/* move data out */
		length = ntohl(request.length);
		p = request.buff;
		for (i=0;i<length;i++,count++) *buff++ = *p++;
	}
	if (status != 0)
		error("transfer with '%s' failed",node);

	/* close channels */
	close(fd);

	/* that's all folks */
	return(count);
}
#endif
