/* sfsbase -- return base address for sfs software */

#include "SFSCONFG.h"
#ifdef WIN32
#include <windows.h>
#include <math.h>
#endif
#include <stdio.h>
#include "sfs.h"

char *sfsbase()
{
	char 		*s;
	char 		*getenv();
	static char 	*t = SFS_BASE_DIRECTORY;

#ifdef WIN32
	char	kname[SFSMAXFILENAME];
	static char	dname[SFSMAXFILENAME];
	unsigned long	ktype,ksize=sizeof(dname);
	int	i;
	HKEY	hKey;
	double	version=0;

	if ((s=getenv("SFSBASE"))) return(s);

	/* find entry for the latest version */
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,"SOFTWARE\\SFS\\SFS\\",0,KEY_EXECUTE,&hKey)==ERROR_SUCCESS) {
		i=0;
		while (RegEnumKey(hKey,i++,dname,sizeof(dname))==ERROR_SUCCESS) {
			if (atof(dname) > version) {
				sprintf(kname,"SOFTWARE\\SFS\\SFS\\%s\\",dname);
				version = atof(dname);
			}
#ifdef IAG
			printf("%d) '%s' key='%s'\n",i,dname,kname);
#endif
		}
		RegCloseKey(hKey);
	}

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,kname,0,KEY_EXECUTE,&hKey)==ERROR_SUCCESS) {

		if (RegQueryValueEx(hKey,"BaseDir",NULL,&ktype,dname,&ksize)==ERROR_SUCCESS) {
			if (ktype==REG_SZ) return(dname);
		}
		RegCloseKey(hKey);
	}
#endif

	if ((s=getenv("SFSBASE")))
		return(s);
	else
		return(t);
}

#ifdef IAG
main()
{
	printf("SFSBASE = %s\n",sfsbase());
}
#endif
