/* sfsclose -- close fid opened with sfsopen */

/* version 1.0 - August 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"
#include "sfsdata.h"

int	sfsclose(fid)
int		fid;
{
	int	ret;

	/* check fid opened */
	if ((fid < 0) ||
	    (fid > MAXFILES) ||
	    (!sfsdata[fid]))
		return(-1);

	/* check no linked fids */
	if (sfsdata[fid]->lfid) sfsclose(sfsdata[fid]->lfid);

	/* close channel */
	ret=close(fid);

	/* check not open for output */
	if (sfsdata[fid]->mode==SFSWRITE) unlink(sfsdata[fid]->ofilename);

	/* lose sfsdata */
	free(sfsdata[fid]);
	sfsdata[fid]=NULL;

	/* return close code */
	return(ret);
}
