/* sfsdup -- duplicate fid opened with sfsopen */

/* version 1.0 - August 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"
#include "sfsdata.h"

int	sfsdup(fid)
int		fid;
{
	int	fid2;

	/* check fid opened */
	if ((fid < 0) ||
	    (fid > MAXFILES) ||
	    (!sfsdata[fid]))
		return(-1);

	/* duplicate channel */
	if ((fid2 = dup(fid)) < 0)
		return(-1);
	
	/* lose sfsdata */
	if (sfsdata[fid2]==NULL) {
		if ((sfsdata[fid2]=(struct sfsdata *)malloc(sizeof(struct sfsdata)))==NULL) {
			close(fid2);
			return(-1);
		}
	}
	*sfsdata[fid2] = *sfsdata[fid];

	/* return channel */
	return(fid2);
}

#ifdef IAG
main()
{
	char    filename[80];
	struct item_header item;
	int     it,fid,fid2,code;
	char    match[80];

	printf("Enter filename : "); fflush(stdout);
	scanf("%s",filename);
	if ((fid=sfsopen(filename,"r",NULL)) < 0) exit(1);
	fid2 = sfsdup(fid);

	printf("1. Enter Item type     : ");
	fflush(stdout);
	scanf("%d",&it);
	printf("1. Enter history match : ");
	fflush(stdout);
	scanf("%s",match);
	code = sfsitem(fid,it,match,&item);
	if (code == 0) 
		printf("item not found\n");
	else {
		printf("item %ld.%02ld history=%s\n",
			item.datatype,
			item.subtype,
			item.history);
	}
	printf("2. Enter Item type     : ");
	fflush(stdout);
	scanf("%d",&it);
	printf("2. Enter history match : ");
	fflush(stdout);
	scanf("%s",match);
	code = sfsitem(fid2,it,match,&item);
	if (code == 0) 
		printf("item not found\n");
	else {
		printf("item %ld.%02ld history=%s\n",
			item.datatype,
			item.subtype,
			item.history);
	}
}
#endif
