/* sfsopen -- open valid sfs file and get main header */

/* version 1.0 - June 1987 */

/* version 1.1 - May 1989
	- 'c' with supplied header works correctly
	- speaker field no longer initialised to username
*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/file.h>
#include <fcntl.h>
#include <time.h>
#include "sfs.h"
#include "sfsdata.h"

/* operation table */
#define READHEAD 1
#define WRITEHEAD 2
#define UPDATE	3
#define CREATE	4
static struct {
	char	*name;
	int	func;
	int	accessmode;
	int	openmode;
} op[]={
#if defined(DOS)||defined(WIN32)
	{ "r",	READHEAD,	R_OK,		O_RDONLY | O_BINARY },
	{ "h",	WRITEHEAD,	R_OK | W_OK,	O_RDWR | O_BINARY },
	{ "w",	UPDATE,		R_OK | W_OK,	O_RDONLY | O_BINARY },
	{ "c",	CREATE,		0,		O_WRONLY | O_CREAT | O_BINARY | O_TRUNC },
#else
	{ "r",	READHEAD,	R_OK,		O_RDONLY },
	{ "h",	WRITEHEAD,	R_OK | W_OK,	O_RDWR },
	{ "w",	UPDATE,		R_OK | W_OK,	O_RDONLY },
	{ "c",	CREATE,		0,		O_WRONLY | O_CREAT },
#endif
	{ 0,	0,	0,	0 }
};

/* load file identifier */
int sfsload_file_id(fid)
struct file_id *fid;
{
	FILE	*idfile;
	char	idname[80];

	/* open id file */
	strcpy(idname,sfsbase());
	strcat(idname,"/dbase.id");
	if ((idfile = fopen(idname,"r+")) == NULL ) {
		/* can't so this - but don't complain */
		fid->site[0]='S';
		fid->site[1]='F';
		fid->site[2]='S';
		fid->site[3]='\0';
		fid->num=1;
		if ((idfile = fopen(idname,"w")) == NULL )
			return(1);
		fprintf(idfile,"%s %d\n",fid->site,fid->num+1);
		fclose(idfile);
		return(0);
	}

	/* get and update id file */
	fscanf(idfile,"%3s%d",fid->site,&fid->num);
	rewind(idfile);
	fprintf(idfile,"%s %d\n",fid->site,fid->num+1);
	fclose(idfile);
	return(0);
}

int	sfsopen(name,mode,head)
const char	*name;			/* pathname of file */
const char	*mode;			/* access mode required */
struct main_header *head;	/* returned main header */
{
	int	i,fid;
	struct main_header htemp;
	int	func,entry;
	char	*ptr;

	/* get function required */
	entry = 0;
	func = -1;
	while (op[entry].name) {
		if (strcmp(mode,op[entry].name) == 0) {
			func=op[entry].func;
			break;
		}
		entry++;
	}
	if (func < 0) return(-2);	/* bad mode */

	/* check file accesses */
	if (func == CREATE) {
		if (access(name,F_OK) == 0)
			return(-2);	/* file exists */
	}
	else {
		if (access(name,F_OK) != 0)
			return(-1);	/* file not found */
		if (access(name,op[entry].accessmode) != 0)
			return(-2);	/* incorrect access */
	}

	/* open given filename */
	if ((fid = open(name,op[entry].openmode,(int)0664)) < 0)
		return(-2);		/* unable to open */

	/* check # files */
	if (fid >= MAXFILES) {
		close(fid);
		return(-2);
	}

	/* perform operation */
	switch (func) {
	case READHEAD:
	case UPDATE:
		/* read in main header and check */
		if (!head) head = &htemp;
		if ((read(fid,head,sizeof(struct main_header)) !=
			sizeof(struct main_header)) ||
			(strcmp(head->hname,"UC2"))) {
			close(fid);
			return(-2);
		}
		if (head->machine != SFSMACHINE)
			sfsconvm(head);
		/* start up record of item */
		if (sfsdata[fid]==NULL) {
			sfsdata[fid]=(struct sfsdata *)malloc(sizeof(struct sfsdata));
			if (sfsdata[fid]==NULL) {
				close(fid);
				return(-2);
			}
		}
		sfsdata[fid]->mode=SFSREAD;
		strcpy(sfsdata[fid]->filename,name);
		sfsdata[fid]->item.length=0;
		sfsdata[fid]->datastart=lseek(fid,0L,1);
		sfsdata[fid]->currpos=sfsdata[fid]->datastart;
		sfsdata[fid]->start=0;
		sfsdata[fid]->numf=0;
		sfsdata[fid]->lfid=0;
		sfsdata[fid]->multiplex=0;
		sfsdata[fid]->swab=0;
		sfsdata[fid]->dcoffset=0;
		sfsdata[fid]->shift=0;
		return(fid);
		break;
	case WRITEHEAD:
		/* write main header */
		if (!head) {
			head = &htemp;
			ptr = (char *) head;
			for (i=0;i<sizeof(struct main_header);i++)
				*ptr++ = '\0';
			strcpy(head->source,head->fid.site);
			strcpy(head->dbase,"temp");
			strcpy(head->speaker,"");
			strcpy(head->session,"");
			strcpy(head->sessdate,"");
			strcpy(head->token,"");
			strcpy(head->rep,"");
#ifdef WIN32
			strcpy(head->environment,"");
#else
			strcpy(head->environ,"");
#endif
			strcpy(head->archive,"");
			strcpy(head->comment,"default header");
			strcpy(head->hname,"UC2");
			head->creatdate = (int32)time((time_t *) 0);
#ifndef DOS
			cuserid(head->username);
#endif
			sfsload_file_id(&head->fid);
			head->machine = SFSMACHINE;
		}
		if (write(fid,head,sizeof(struct main_header)) !=
			sizeof(struct main_header)) {
			close(fid);
			return(-2);
		}
		close(fid);
		return(0);
		break;
	case CREATE:
		/* create new file */
		/* create default header */
		if (!head) {
			head = &htemp;
			ptr = (char *) head;
			for (i=0;i<sizeof(struct main_header);i++)
				*ptr++ = '\0';
			strcpy(head->source,head->fid.site);
			strcpy(head->dbase,"temp");
			strcpy(head->speaker,"");
			strcpy(head->session,"");
			strcpy(head->sessdate,"");
			strcpy(head->token,"");
			strcpy(head->rep,"");
#ifdef WIN32
			strcpy(head->environment,"");
#else
			strcpy(head->environ,"");
#endif
			strcpy(head->archive,"");
			strcpy(head->comment,"default header");
		}
		strcpy(head->hname,"UC2");
		head->creatdate = (int32)time((time_t *) 0);
#ifndef DOS
		cuserid(head->username);
#endif
		sfsload_file_id(&head->fid);
		head->machine = SFSMACHINE;
		/* write main header */
		if (write(fid,head,sizeof(struct main_header))
			!= sizeof(struct main_header)) {
			close(fid);
			return(-2);
		}
		/* ensure owner is user, but group is db */
#ifndef DOS
		chown(name,getuid(),getegid());
#endif
		close(fid);
		return(0);
		break;
	}
	return(-2);
}


#ifdef IAG
main()
{
	int	fid;
	char	filename[80],ans[80];
	struct main_header head;

	for (;;) {
		printf("Enter filename: ");
		fflush(stdout);
		scanf("%s",filename);
		fid = sfsopen(filename,"r",&head);
		if (fid>=0) {
			printf("%s is ok for reading\n",filename);
			close(fid);
			fid = sfsopen(filename,"w",NULL);
			if (fid>=0) printf("%s is ok for writing\n",filename);
		}
		else {
			if (fid==-2)
				 printf("%s cannot be accessed\n",filename);
			else {
				printf("%s does not exist, create ? (y/n) : ",filename);
				fflush(stdout);
				scanf("%s",ans);
				if (ans[0]=='y') {
					fid = sfsopen(filename,"c",NULL);
					if (fid < 0) printf("error creating %s\n",filename);
				}
			}
		}
	}
}
#endif
