/* sfsopenlink -- open a channel to a linked item */

/* M.A.Huckvale - August 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "sfs.h"
#include "sfsdata.h"

int sfsopenlink(fid)
int		fid;		/* file identifier for item */
{
	char	fullpath[2*SFSMAXFILENAME];
	char	*p;
	struct item_header item;
	struct link_header link;
	struct stat	filestat;
	char	subtxt[8];
	int	lfid= -1;
	unsigned long	mtime;

	/* read in link header */
	lseek(fid,sfsdata[fid]->datastart,0);
	read(fid,&link,sizeof(struct link_header));
	sfsdata[fid]->currpos=lseek(fid,0L,1);

	/* find pathname */
	if ((link.filename[0]=='/') || (link.filename[0]=='\\'))
		strcpy(fullpath,link.filename);
#ifdef DOS
	else if ((link.filename[1]==':') && ((link.filename[2]=='/') || (link.filename[2]=='\\')))
		strcpy(fullpath,link.filename);
#endif
	else {
		strcpy(fullpath,sfsdata[fid]->filename);
		if ((p=strrchr(fullpath,'/')) || (p=strrchr(fullpath,'\\')))
			*(p+1)='\0';
		else
			strcpy(fullpath,"");
		strcat(fullpath,link.filename);
	}

	/* open SFS file */
	if (link.filetype==SFS_TYPE) {
		/* open sfs file */
		if ((lfid=sfsopen(fullpath,"r",NULL)) < 0)
			return(-1);
		/* find item */
		sprintf(subtxt,"%d",link.subtype);
		if (sfsitem(lfid,link.datatype,subtxt,&item) == 0)
			return(-1);
		/* check date */
		if (item.processdate > link.linkdate)
			fprintf(stderr,"sfs warning: linked item out of date (%ld,%ld)\n",item.processdate,link.linkdate);
		/* move start of data set */
		sfsdata[lfid]->datastart += link.offset;
	}
	else if (link.filetype==BINARY_TYPE) {
		/* open channel to binary file */
#if defined(DOS)||defined(WIN32)
		if ((lfid=open(fullpath,O_RDONLY | O_BINARY)) < 0)
#else
		if ((lfid=open(fullpath,O_RDONLY)) < 0)
#endif
			return(-1);
		/* check # channel sopen */
		if (lfid >= MAXFILES) {
			close(lfid);
			return(-1);
		}
		if (sfsdata[lfid]==NULL) {
			sfsdata[lfid]=(struct sfsdata *)malloc(sizeof(struct sfsdata));
			if (sfsdata[lfid]==NULL) {
				close(lfid);
				return(-1);
			}
		}
		sfsdata[lfid]->mode=SFSREAD;
		strcpy(sfsdata[lfid]->filename,fullpath);
		sfsdata[lfid]->datastart=lseek(lfid,0L,1);
		sfsdata[lfid]->currpos=sfsdata[lfid]->datastart;
		sfsdata[lfid]->start=0;
		sfsdata[lfid]->numf=0;
		sfsdata[lfid]->lfid=0;
		sfsdata[lfid]->item=sfsdata[fid]->item;
		sfsdata[lfid]->multiplex=link.multiplex;
		sfsdata[lfid]->swab=link.swab;
		sfsdata[lfid]->dcoffset=link.dcoffset;
		sfsdata[lfid]->shift=link.shift;
		/* check date */
		fstat(lfid,&filestat);
		mtime = *(unsigned long *)(&filestat.st_mtime);
#ifdef DOS
		if (mtime > (link.linkdate+18000))
#else
		if (mtime > link.linkdate)
#endif
			fprintf(stderr,"sfs warning: linked item out of date (%ld,%ld)\n",mtime,link.linkdate);
		/* move start of data set */
		sfsdata[lfid]->datastart += link.offset;
	}
	else if (link.filetype==(NETWORK_TYPE | BINARY_TYPE)) {
		/* open any old channel */
		if ((lfid=open("/dev/tty",O_WRONLY)) < 0)
			return(-1);
		/* check # channel sopen */
		if (lfid >= MAXFILES) {
			close(lfid);
			return(-1);
		}
		if (sfsdata[lfid]==NULL) {
			sfsdata[lfid]=(struct sfsdata *)malloc(sizeof(struct sfsdata));
			if (sfsdata[lfid]==NULL) {
				close(lfid);
				return(-1);
			}
		}
		sfsdata[lfid]->mode=NETREAD;
		strcpy(sfsdata[lfid]->filename,link.filename);
		strcpy(sfsdata[lfid]->ofilename,link.filepath);
		sfsdata[lfid]->datastart=link.offset;
		sfsdata[lfid]->currpos=0;
		sfsdata[lfid]->start=0;
		sfsdata[lfid]->numf=0;
		sfsdata[lfid]->lfid=0;
		sfsdata[lfid]->item=sfsdata[fid]->item;
		sfsdata[lfid]->multiplex=link.multiplex;
		sfsdata[lfid]->swab=link.swab;
		sfsdata[lfid]->dcoffset=link.dcoffset;
		sfsdata[lfid]->shift=link.shift;
#ifdef NETCHECK		/* don't check file to improve performance */
		/* check date */
		netaccess(link.filepath,link.filename,&filestat.st_size,&filestat.st_mtime);
		if (filestat.st_mtime > link.linkdate)
			fprintf(stderr,"sfs warning: linked item out of date (%ld,%ld)\n",filestat.st_mtime,link.linkdate);
#endif
	}

	/* return file descriptor as handle */
	return(lfid);
}
