/* sfswrite -- write frames to output file */
/* sun4 mods - C M Ayer - August 1989 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include "sfs.h"
#include "sfsdata.h"

int32 sfswrite(fid,numf,buff)
int		fid;
int32		numf;
void		*buff;
{
	int32	fhead,fsize;
	int32	numb,numo;
	unsigned char	*s,*lasts=NULL;
	int	i,clen;

	/* check output file ok */
	if (!sfsdata[fid] ||
	    (sfsdata[fid]->mode != SFSWRITE) ||
	    (numf <= 0))
		return(0);

	/* get size of frame and header */
	fsize = sfsdata[fid]->item.datasize * sfsdata[fid]->item.framesize;

	fhead = sfsstruct[sfsdata[fid]->item.datatype];
	if (fhead == 0) {
		/* unstructured data */
		numb = numf * fsize;
		numo = write(fid,buff,numb);
		sfsdata[fid]->item.numframes += numo/fsize;
		sfsdata[fid]->item.length += numo;
		sfsdata[fid]->item.lastposn = sfsdata[fid]->item.numframes;
		return(numo/fsize);
	}
	else if (sfsdata[fid]->item.framesize > 0) {
		/* fixed-length structured data */
		s = (char *) buff;
		numo = 0;
		for (i=0;i<numf;i++) {
			numo += write(fid,s,fhead);
			lasts = s;
			s += fhead;
			numo += write(fid,*(char **)s,fsize-fhead);
			s += sizeof(char *);
		}
		sfsdata[fid]->item.numframes += numo/fsize;
		sfsdata[fid]->item.length += numo;
		if (lasts) switch (sfsdata[fid]->item.datatype) {
		case DI_TYPE:
			sfsdata[fid]->item.lastposn = ((struct di_rec *)lasts)->posn+((struct di_rec *)lasts)->size;
			break;
		case VU_TYPE:
			sfsdata[fid]->item.lastposn = ((struct vu_rec *)lasts)->posn+((struct vu_rec *)lasts)->size;
			break;
		case CO_TYPE:
			sfsdata[fid]->item.lastposn = ((struct co_rec *)lasts)->posn+((struct co_rec *)lasts)->size;
			break;
		case PC_TYPE:
			sfsdata[fid]->item.lastposn = ((struct pc_rec *)lasts)->posn+((struct pc_rec *)lasts)->size;
			break;
		case EN_TYPE:
			sfsdata[fid]->item.lastposn = ((struct en_rec *)lasts)->posn+((struct en_rec *)lasts)->size;
			break;
		case FM_TYPE:
			sfsdata[fid]->item.lastposn = ((struct fm_rec *)lasts)->posn+((struct fm_rec *)lasts)->size;
			break;
		}
		return(numo/fsize);
	}
	else {
		s = (char *) buff;
		numo = 0;
		for (i=0;i<numf;i++) {
			clen = fhead + strlen(*(char **)(s+fhead)) + 1;
			numo += write(fid,&clen,1);
			numo += write(fid,s,fhead);
			lasts = s;
			s += fhead;
			numo += write(fid,*(char **)s,clen-fhead);
			s += sizeof(char *);
		}
		sfsdata[fid]->item.numframes += numf;
		sfsdata[fid]->item.length += numo;
		if (lasts) switch (sfsdata[fid]->item.datatype) {
		case AN_TYPE:
			sfsdata[fid]->item.lastposn = ((struct an_rec *)lasts)->posn+((struct an_rec *)lasts)->size;
			break;
		case WD_TYPE:
			if (((struct wd_rec *)lasts)->end > sfsdata[fid]->item.lastposn)
				sfsdata[fid]->item.lastposn = ((struct wd_rec *)lasts)->end;
			break;
		}
		return(numf);
	}
}

#ifdef IAG
main()
{
	char	filename[80],spec[80];
	struct main_header head;
	struct item_header item,newitem;
	char	*buff,*ty;
	int	fid,ofid,it,i;

	printf("Enter filename : ");
	fflush(stdout);
	scanf("%s",filename);
	if ((fid=sfsopen(filename,"r",&head)) < 0)
		error("cannot open %s",filename);

	printf("Enter item spec : ");
	fflush(stdout);
	scanf("%s",spec);
	if (itspec(spec,&it,&ty)!=0)
		error("bad item spec: %s",spec);

	if (!sfsitem(fid,it,ty,&item))
		error("cannot find item %s",spec);

	if ((buff=sfsbuffer(&item,item.numframes))==NULL)
		error("could not create memory buffer",NULL);

	if (sfsread(fid,0,item.numframes,buff) != item.numframes)
		error("could not read data set",NULL);

	sfsheader(&newitem,item.datatype,item.floating,
			item.datasize,item.framesize,
			item.frameduration,item.offset,
			item.windowsize,item.overlap,
			item.lxsync);
	sprintf(newitem.history,"sfswrite(file=%s,item=%d.%02d)",
		filename,item.datatype,item.subtype);
	strcpy(newitem.params,"");

	if ((ofid=sfschannel(filename,&newitem)) < 0)
		error("could not open output channel",NULL);

	i = write(ofid,&head,sizeof(struct main_header));
#if SFS_SWAP_HEADER
	/* always swap out of sun4 format */
	sun4unswap(&item);
#endif
	i = write(ofid,&item,sizeof(struct item_header));

	if (sfswrite(ofid,item.numframes,buff) != item.numframes)
		error("write error on output",NULL);

	i = lseek(ofid,(long)sizeof(struct main_header),0);
#if SFS_SWAP_HEADER
	/* always swap out of sun4 format */
	sun4unswap(&item);
#endif
	i = write(ofid,&sfsdata[fid]->item,sizeof(struct item_header));

	close(ofid);
	close(fid);

	printf("created output file with copy of item\n");
	exit(0);
}
#endif
