/* apply -- apply a program to a number of files */

/* Mark Huckvale - Univserity College London */

/* version 1.0 - April 1997 */

#define PROGNAME "apply"
#define PROGVERS "1.0"
char *progname=PROGNAME;

/*-------------------------------------------------------------------------*/
/**MAN
.TH APPLY SFS1 UCL
.SH NAME
apply -- apply a program to a number of files
.SH SYNOPSIS
.B apply
(-i) program file(s)
.SH DESCRIPTION
.I apply
is a program to run an SFS program on a number of files.  The first
argument is taken to be the name of the program and any optional
parameters, the second and subsequent arguments are taken to be a
list of files to be operated upon.  An option allows the selection
of which files are to be chosen.
.SH OPTIONS
.TP 11
.B -I
Identify program name and version number.
.TP 11
.B -i
Interactive mode.  Press 'y' to process, 'n' to skip, 'q' to quit.
.SH VERSION/AUTHOR
.IP 1.0
Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "sfs.h"

void main(argc,argv)
int argc;
char *argv[];
{
	extern int optind;
	extern char * optarg;
	int	c,errflg=0;
	int	doask=0;
	int	i;
	char	comstr[1024];
	char	ans[80];
	
	while ((c=getopt(argc,argv,"Ii"))!=EOF) switch (c) {
	case 'I':
		fprintf(stderr,"%s: Apply program to multiple files V%s\n",
			PROGNAME,PROGVERS);
		exit(0);
	case 'i':
		doask=1;
		break;
	default:
		errflg=1;
		break;
	}
	if (errflg || (argc < 2))
		error("usage: %s (-i) program files",PROGNAME);

	for (i=optind+1;i<argc;i++) {
		if (doask) {
			printf("%s (y/n/q) ? : ",argv[i]);
			gets(ans);
			if (tolower(ans[0]=='q')) exit(0);
			if (tolower(ans[0]!='y')) continue;
		}
		else
			printf("%s\n",argv[i]);
		sprintf(comstr,"%s %s",argv[optind],argv[i]);
		system(comstr);
	}
	exit(0);
}
