/* filter.h -- General Purpose Digital Filter Routines */

/* Mark Huckvale - University College London */

/* maximum sizes */
#define FILTER_MAX_ORDER	20

/* filter types */
#define FILTER_LOW_PASS		1
#define FILTER_HIGH_PASS	2
#define FILTER_BAND_PASS	3
#define FILTER_BAND_STOP	4

/* structure of a filter section */
typedef struct FILTER_SECTION {
	short	ncoeff;
	float	*acoeff;
	float	*bcoeff;
	float	*memory;
} FILTER_SECTION;

/* structure of a filter */
typedef struct FILTER {
	short	nsection;
	FILTER_SECTION	*section;
} FILTER;

/* complex data type */
typedef struct {
	double	re,im;
} complex;

/* function prototypes */
FILTER * filter_design(
#ifdef __STDC__
int,			/* filter type */
int,			/* filter order */
double,			/* lower band edge */
double,			/* upper band edge */
double			/* sampling frequency */
#endif
);

void	filter_free(
#ifdef __STDC__
FILTER *
#endif
);

void	filter_clear(
#ifdef __STDC__
FILTER *
#endif
);

void	filter_signal(
#ifdef __STDC__
FILTER *,		/* filter */
short *,		/* input signal */
short *,		/* output signal */
int			/* # samples */
#endif
);

double	filter_response(
#ifdef __STDC__
FILTER *,		/* filter */
double,			/* response freq */
double			/* sampling freq */
#endif
);
