/* matrix arithmetic support library definitions */

/* version 2 - October 1988 */

#include <malloc.h>

/* matrix structure */
typedef struct {
	int	row;
	int	col;
	double	*ptr;
	char	*name;
} matrix;

/* matrix functions */
#ifdef __STDC__
int 	mataddscalar(matrix *,matrix *,double);
int 	matmultscalar(matrix *,matrix *,double);
int 	matident(matrix *);
int 	matadd(matrix *,matrix *,matrix *);
int 	matsub(matrix *,matrix *,matrix *);
int 	matmult(matrix *,matrix *,matrix *);
int 	mattrans(matrix *,matrix *);
matrix 	*matcreate(int,int,char *);
int 	matdelete(matrix *);
void 	materror(char *,char *,matrix *,matrix *);
int 	matcopy(matrix *,matrix *);
int 	matsubmatrix(matrix *,matrix *,int,int,int,int);
void 	_matxfer(matrix *,matrix *);
int 	matinput(matrix *,FILE *);
int 	matprint(matrix *,FILE *,char *);
double	matinv(matrix *,matrix *);
double	matsolve(matrix *,matrix *,matrix *);
int	matcorr_init(int,int);
int	matcorr_free(void);
int	matcorr_add(int,double *);
int	matcorr_mean(int,matrix *);
int	matcorr_devsscp(int,matrix *);
int	matcorr_covar(int,matrix *);
int	matcorr_correl(int,matrix *);
int	mateigen(matrix *,matrix *,matrix *);
int	matdiagrnm(matrix *,matrix *,matrix *,matrix *);
int	matprinc(matrix *,matrix *,matrix *);
int	matlda(matrix *,matrix *,int *,matrix *,matrix *,int,int);
#else
matrix 	*matcreate();
double	matinv();
double	matsolve();
#endif

/* matrix error */
#define MATERRABORT	0
#define MATERRWARN	1
#define MATERRIGNORE	2
extern int materrlevel;

/* calculation epsilon */
#define EPSILON 1.0E-15

/* matrix access macro */
#define MATRIX(a,r,c) (*(a->ptr+r*a->col+c))
