/* circle -- draw a DIG circle given centre and radius */

#include <stdio.h>
#include <math.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#ifdef __STDC__
void   digcircle(int  bundle,float  xc,float  yc,float  radius)
#else
void	digcircle(bundle,xc,yc,radius)
int	bundle;
float	xc,yc,radius;
#endif
{
	int	x,y,r;

	x = xpix(xc);
	y = ypix(yc);
	r = xpix(xc+radius) - x;	/* radius using x co-ordinates */

	digcirclep(bundle,x,y,r);
}

void	digcirclep(bundle,xc,yc,radius)
int	bundle;
int	xc,yc,radius;
{
	/* check if device has special routine */
	if (digtable[digdata.select].circle)
		/* call special routine */
		(*digtable[digdata.select].circle)(bundle,xc,yc,radius);
	else
		/* use arc routine */
		digarcp(bundle,xc-radius,yc,xc+radius,yc,xc-radius,yc);
}


#ifdef EMO
main()
{
	int	i;

	digstart('\0',NULL,0);
	digscale (21.0,21.0,1);
	digclearscreen();
/*
	for (i=7;i>=1;i--)
		digcircle(i,7.0,10.0,(float)i);
	for (i=7;i>=1;i--)
		digcircle(20+i,14.0,10.0,(float)i);
*/
	digcircle(20,10.0,10.0,7.5);
	digend();
}
#endif
