/* xdig -- DIG routines for X-Windows with XVIEW library */

/* M.A.Huckvale - University College London */

/* version 0.1 - December 1992 */

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <sys/types.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"

#ifdef EVx

#include <sys/socket.h>
#include "xdig.h"

struct digDEVx_t digDEVx;


/* start the child process running */
#define READ	0
#define WRITE	1
static forkchild()
{
	int	csock[2],psock[2];

	/* get two pipes */
	if (pipe(csock) < 0) {
		fprintf(stderr,"could not open pipe\n");
		exit(1);
	}
	if (pipe(psock) < 0) {
		fprintf(stderr,"could not open pipe\n");
		exit(1);
	}
	digDEVx.pout = psock[WRITE];
	digDEVx.pin = csock[READ];
	digDEVx.cout = csock[WRITE];
	digDEVx.cin = psock[READ];

	if ((digDEVx.mode = fork()) < 0) {
		error("could not start display process");
	}
	else if (digDEVx.mode!=0) {
		/* this is parent process */
		close(digDEVx.cout);
		close(digDEVx.cin);
	}
	else {
		/* this is child process */
		close(digDEVx.pout);
		close(digDEVx.pin);
		/* display graphics on command */
		dographics();
		exit(0);
	}
}

/* send a command to the child process */
static char obuf[OBUFSIZE];
int	ocnt;

static gcommand(str,flush)
char *str;
int flush;
{
	while (*str) {
		obuf[ocnt++] = *str++;
		if (ocnt==OBUFSIZE) {
			write(digDEVx.pout,obuf,ocnt);
			ocnt=0;
		}
	}
	if (flush && ocnt) {
		write(digDEVx.pout,obuf,ocnt);
		ocnt=0;
	}
}
static gdata(buf,len,flush)
char *buf;
int len;
int flush;
{
	while (len-- > 0) {
		obuf[ocnt++] = *buf++;
		if (ocnt==OBUFSIZE) {
			write(digDEVx.pout,obuf,ocnt);
			ocnt=0;
		}
	}
	if (flush && ocnt) {
		write(digDEVx.pout,obuf,ocnt);
		ocnt=0;
	}
}

/* get a command from the child */
static readchild(msg)
char *msg;
{
	/* blocking I/O is sufficient */
	read(digDEVx.pin,msg,RCOMMLEN);
/*
	printf("XDIG: got '%s'\n",msg);
*/
}

/* device characteristics */
xdig_params(subtype,digdev)
int	subtype;
struct digdevice *digdev;
{
	char	cmessg[RCOMMLEN];
	int	width,height,cwidth,cheight,ngrey;

	/* see if child process running */
	if (!digDEVx.mode) {
		/* start child process */
		forkchild();
	}

	/* request screen parameters */
	gcommand("q\n"); 
	do {
		readchild(cmessg);
	} while (cmessg[0]!='S');
	sscanf(cmessg,SCRMESS,&width,&height,&cwidth,&cheight,&ngrey);

	/* return device characteristics */
	digdev->nhoriz = width-1;
	digdev->nvert = height-1;
	digdev->aspect = 1.0;
	digdev->chwidth = cwidth;
	digdev->chheight = cheight-1;
	digdev->greylevels = ngrey;
	digdev->greypixwidth = 1;
	digdev->greypixheight = 1;

}

/* open graphics */
xdig_open()
{
	if (!digDEVx.mode) {
		forkchild();
	}
	gcommand("g1\n",1);	/* init graphics */
}

/* interrupt graphics */
xdig_inter()
{
	xdig_close();
}

/* close graphics - return to text mode */
xdig_close()
{
	gcommand("g0\n",1);	/* close graphics */
	/* this should stop child process */
	close(digDEVx.pout);
	wait(NULL);		/* wait for child to stop */
	digDEVx.mode=0;
}

/* clear screen */
xdig_clear()
{
	gcommand("k\n",1);
}

/* poly line */
xdig_polyline(bundle,buff,len)
int	bundle;
short	*buff;
int	len;
{
	int	x,y;
	char	messg[32];
	
	/* check colour */
	if (bundle != digDEVx.currbun) {
		sprintf(messg,"h%d\n",bundle);
		gcommand(messg,0);
		digDEVx.currbun=bundle;
	}

	/* position to first point */
	x = *buff++;
	y = *buff++;
	sprintf(messg,"p%d;%d\n",x,y);
	gcommand(messg,0);
	len -= 2;

	/* plot rest of points */
	while (len > 0) {
		x = *buff++;
		y = *buff++;
		sprintf(messg,"d%d;%d\n",x,y);
		gcommand(messg,0);
		len -= 2;
	}
	gcommand("",1);
}

/* draw 'hardware' text */
xdig_text(bundle,x,y,str)
int	bundle;
int	x,y;
char	*str;
{
	char	messg[32];
	sprintf(messg,"h%d\np%d;%d\nt",bundle,x,y);
	gcommand(messg,0);
	gcommand(str,0);		/* need to parse into lines */
	sprintf(messg,"\n");
	gcommand(messg,1);
	digDEVx.currbun=bundle;
}

/* draw a filled rectangle */
xdig_fillrect(bundle,x1,y1,x2,y2)
int	bundle;
int	x1,y1,x2,y2;
{
	char	messg[32];
	sprintf(messg,"h%d\np%d;%d\nb%d;%d\n",bundle,x1,y1,x2,y2);
	gcommand(messg,1);
	digDEVx.currbun=bundle;
}

/* change line/text raster operation */
xdig_rasterop(mode)
int	mode;
{
	int	ret;
	char	messg[32];
	sprintf(messg,"l%d\n",mode);
	gcommand(messg,0);
	ret=digDEVx.rop;
	digDEVx.rop=mode;
	return(ret);
}

/* initialise pointing device */
xdig_pointer(flag,xm,ym)
int	flag;
int	xm,ym;
{
	char	messg[32];
	if (flag) {
		sprintf(messg,"o1\n");
	}
	else {
		sprintf(messg,"o0\n");
	}
	gcommand(messg,1);
}

/* get mouse/key status */
xdig_mouse(but,xm,ym,ich)
int	*but;
int	*xm;
int	*ym;
int	*ich;
{
	char	cmessg[RCOMMLEN];

	while (1) {
		readchild(cmessg);
		switch (cmessg[0]) {
		case 'R':
			/* redraw command */
			return(DIG_REDRAW);
		case 'K':
			/* keyboard command */
			sscanf(cmessg,KEYMESS,ich);
			return(DIG_KEY);
		case 'M':
			/* mouse command */
			sscanf(cmessg,MOUMESS,xm,ym,but);
			return(DIG_MOUSE);
		case 'Q':
			/* quit command */
			return(DIG_QUIT);
		}
	}
}

/* display text on prompt line */
xdig_prompt(str)
char	*str;
{
	char	messg[32];
	sprintf(messg,"H\nK\nt");
	gcommand(messg,0);
	gcommand(str,0);
	gcommand("\n",1);
}

/* grey-level display */
xdig_gscale(x,y,height,buff)
int	x,y;
int	height;
unsigned char	*buff;
{
	int		i;
	char		messg[32];
	unsigned char 	*p,lastc;

	/* replace greyscales by colours */
	p=buff;
	sprintf(messg,"p%d;%d\n",x,y+height-1);
	gcommand(messg,0);
	lastc=*p++;
	for (i = 1; i < height; i++, p++) {
		if (*p != lastc) {
			sprintf(messg,"h%d\nd%d;%d\n",lastc+100,x,y+height-i-1);
			gcommand(messg,0);
			lastc = *p;
		}
	}
	sprintf(messg,"h%d\nd%d;%d\n",lastc+100,x,y);
	gcommand(messg,1);
}

/* pause for user input */
int xdig_pause()
{
	char	cmessg[RCOMMLEN];

	while (1) {
		readchild(cmessg);
		switch (cmessg[0]) {
		case 'R':
			/* redraw command */
			return(DIG_REDRAW);
		case 'K':
			/* keyboard command */
			return(DIG_KEY);
		case 'M':
			/* mouse command */
			return(DIG_MOUSE);
		case 'Q':
			/* quit command */
			return(DIG_QUIT);
		}
	}
}

#endif
