/* DSP routines from Mike Brookes, Imperial College London */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "libic.h"

void cbitrev(data,len)
COMPLEX *data;
int len;
{
/*
Float array bit reversal reordering routine

len = 2**m
*/
    REAL temp;
    int i,n1,n2;
    register int j,k;

    n1 = len-1;
    j = n2 = len >> 1;
    for (i=1; i<n1; i++) {
	if (i<j) {
	    temp = data[j].r;
	    data[j].r = data[i].r;
	    data[i].r = temp;
	    temp = data[j].i;
	    data[j].i = data[i].i;
	    data[i].i = temp;
	    }
	k = n2;
	while (k <= j) {
	    j -= k;
	    k = k >> 1;
	    }
	j += k;
	}
    }

#ifdef EMO

#define LEN 32

main()
{
    COMPLEX data[LEN];
    int i;

    for (i=0; i<LEN; i++) {
	data[i].r = i;
	data[i].i = i + 0.1;
	}
    cbitrev(data,LEN);
    for (i=0; i<LEN; i++) {
	printf("%5d %6.1f %6.1f\n",i,data[i].r,data[i].i);
	}
    }
#endif
