/* sfstree -- routine to build history tree of data file */

/* returned data structure in "tree" */

#include "SFSCONFG.h"
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "sfs.h"
#include "sfsdata.h"
#include "sfstree.h"		/* global output of sfstree in here */

static upd_exist();

int sfstree(filename)
char	*filename;		/* data file name */
{
	int	i;
	int	fid;			/* file descriptor */
	int	hlen;			/* history length */
	struct	item_header item;	/* item details */

	/* clear if tree exists */
	if (tree != NULL) {
		for (i=0;i<treelen;i++) free(tree[i].history);
		free(tree);
		tree=(struct histrec *)NULL;
	}

	/* create tree structure at max size */
	if ((tree=(struct histrec *)calloc(MAXTREELEN,sizeof(struct histrec)))==NULL)
		error("unable to get memory for tree",NULL);
	/* and clear important values */
	treelen = 0;
	for (i=0;i<MAXTREELEN;i++) {
		tree[i].numlink=0;
		tree[i].level=0;
	}

	/* open data file */
	if ((fid=sfsopen(filename,"r",NULL)) < 0)
		return(0);

	/* check items in data file */
	while (sfsnextitem(fid,&item)) {

		/* record basic details */
		tree[treelen].datatype = item.datatype;
		tree[treelen].subtype = item.subtype;
		tree[treelen].itemstart = sfsdata[fid]->datastart - sizeof(struct item_header);
		sprintf(tree[treelen].itemno,"%d.%02d",abs(item.datatype),item.subtype);
		hlen = strlen(item.history);
		if ((tree[treelen].history=(char *)malloc(hlen+1))==NULL)
			error("unable to get memory for history",NULL);
		strcpy(tree[treelen].history,item.history);

		/* check against other items in file */
		for (i=0;i<treelen;i++) {
			if (upd_exist(tree[i].itemno,item.history)) {
				tree[treelen].link[tree[treelen].numlink]=i;
				tree[treelen].numlink++;
				if (tree[i].level >= tree[treelen].level)
					tree[treelen].level=tree[i].level+1;
			}
		}

		/* next item */
		treelen++;
	}
	sfsclose(fid);

	/* remove spare tree space */
	tree = (struct histrec *)realloc(tree,treelen*sizeof(struct histrec));

	return(1);
}

/* check existence of itemno string in history */
static int upd_exist(s,t)
char	*s,*t;
{
	register int	i,j,flag;
	int	ls,lt;
	ls=strlen(s);
	lt=strcspn(t,";=")-ls;
	for (i=1;i<=lt;i++) {
		if (((t[i-1]=='(') || (t[i-1]==',')) && (s[0]==t[i])) {
			flag=1;
			for (j=1;j<ls;j++) if (s[j]!=t[i+j]) flag=0;
			if ((t[i+j]!=')') && (t[i+j]!=';') && (t[i+j]!=',')) flag=0;
			if (flag) return(1);
		}
	}
	return(0);
}

#ifdef IAG
main()
{
	char	filename[80];
	int	i,j;

	printf("Enter filename : ");
	fflush(stdout);
	scanf("%s",filename);
	if (!sfstree(filename,0))
		error("cannot open %s",filename);

	for (i=0;i<treelen;i++) {
		printf("%2d). %2d.%02d %8s %s\n\tlinks to: ",
			i,
			tree[i].datatype,
			tree[i].subtype,
			tree[i].itemno,
			tree[i].history);
		for (j=0;j<tree[i].numlink;j++) printf("%2d, ",tree[i].link[j]);
		printf("\n\tlevel=%d\n",tree[i].level);
	}

	exit(0);
}
#endif
