/* sfsupdate -- primary database file update routine */
/* sun4 mods - C M Ayer - August 1989 */
/* fixed? bug in updating files in foreign format - March 1998 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include "sfs.h"
#include "sfsdata.h"

/* update local data structures */
static struct {
	int	fid;
	int	datatype;
	char	*history;
} update[MAXFILES];
int	updcount=0;
static struct {
	char	itemno[8];
	int	used;
} current[MAXITEM];
int	curcount=0;

static upd_copy();
static upd_exist();
static upd_files();

#ifdef _MSC_VER
#define LINK upd_cpfiles	/* emulation of link() on DOS */
#else
#define LINK link
#endif

int sfsupdate(dataname)
char	*dataname;
{
	int	i;
	int	fid,out;
	struct	main_header head;
	struct	item_header item;
	int	subtypes[MAXDATATYPE+1];
	int	restruct=0,skip;

	/* get details of update items */
	for (i=0;i<MAXFILES;i++) if (sfsdata[i]) {
		if ((strcmp(sfsdata[i]->filename,dataname)==0) &&
		    (sfsdata[i]->mode==SFSWRITE)) {
			update[updcount].fid=i;
			update[updcount].datatype=sfsdata[i]->item.datatype;
			update[updcount].history=sfsdata[i]->item.history;
			updcount++;
			lseek(i,0L,0);
		}
	}

	/* check if nothing to do */
	if (updcount == 0) return(1);

	/* check items in data file */
	for (i=0;i<=MAXDATATYPE;i++) subtypes[i]=0;
	for (i=0;i<MAXITEM;i++) current[i].used=0;
	if ((fid=sfsopen(dataname,"r",NULL)) < 0) {
		upd_files();
		return(0);
	}
	while (sfsnextitem(fid,&item)) {
		item.datatype=abs(item.datatype);
		/* generate itemno */
		sprintf(current[curcount].itemno,"%d.%02d",item.datatype,item.subtype);
		/* check against other items in file */
		for (i=0;i<curcount;i++) {
			if (upd_exist(current[i].itemno,item.history))
				current[i].used++;
		}
		/* check against items to be added */
		for (i=0;i<updcount;i++) {
			if ((item.datatype==update[i].datatype) &&
			    (strcmp(item.history,update[i].history)==0))
				restruct++;
			if (upd_exist(current[curcount].itemno,update[i].history))
				current[curcount].used++;
		}
		/* keep record of largest subtype in use */
		if (item.subtype>subtypes[item.datatype])
			subtypes[item.datatype]=item.subtype;
		curcount++;
	}
	sfsclose(fid);

	/* if no restructuring, merely append new items */
	if (!restruct) {
#ifdef DOS
		if ((fid=open(dataname,O_WRONLY | O_APPEND | O_BINARY)) < 0) {
#else
		if ((fid=open(dataname,O_WRONLY | O_APPEND)) < 0) {
#endif
			upd_files();
			return(0);
		}
		for (i=0;i<updcount;i++) {
			sfsdata[update[i].fid]->item.subtype = ++subtypes[sfsdata[update[i].fid]->item.datatype];
#if SFS_SWAP_HEADER
			/* always swap out of sun4 format */
			sun4unswap((int32 *)&sfsdata[update[i].fid]->item);
#endif
			if (write(fid,&sfsdata[update[i].fid]->item,sizeof(struct item_header)) != sizeof(struct item_header)) {
				close(fid);
				upd_files();
				return(0);
			}
			if (!upd_copy(sfsdata[update[i].fid]->item.length,update[i].fid,fid)) {
				close(fid);
				upd_files();
				return(0);
			}
		}
		close(fid);
		upd_files();
		return(1);
	}

	/* restructuring required */
	if ((fid=sfsopen(dataname,"r",&head)) < 0) {
		upd_files();
		return(0);
	}
	if ((out = sfschannel(dataname,&item)) < 0) {
		sfsclose(fid);
		upd_files();
		return(0);
	}
	if (write(out,&head,sizeof(struct main_header)) != sizeof(struct main_header)) {
		sfsclose(out);
		sfsclose(fid);
		upd_files();
		return(0);
	}
	for (i=0;i<=MAXDATATYPE;i++) subtypes[i]=0;
	curcount=0;
	while (sfsnextitem(fid,&item)) {
		/* operations: 0=write as norm, 1=truncate, 2=delete */
		skip=0;
		for (i=0;i<updcount;i++) 
			if ((item.datatype==update[i].datatype) &&
			    (strcmp(item.history,update[i].history)==0)) {
				if (current[curcount].used)
					skip=1;
				else
					skip=2;
			}
		if (skip==2) {
			/* ignore whole dataset */
		}
		else if (skip==1) {
			/* leave "stub" of dataset */
			if (item.subtype>subtypes[abs(item.datatype)])
				subtypes[abs(item.datatype)]=item.subtype;
			item.datatype= -(abs(item.datatype));
			item.length=0;
			item.datapresent=0;
			if (item.machine != SFSMACHINE) sfsconvi(&item);
#if SFS_SWAP_HEADER
			/* always swap out of sun4 format */
			sun4unswap((int32 *)&item);
#endif

			if (write(out,&item,sizeof(struct item_header)) != sizeof(struct item_header)) {
				sfsclose(out);
				sfsclose(fid);
				upd_files();
				return(0);
			}
		}
		else /* skip == 0 */ {
			/* copy whole */
			if (item.subtype>subtypes[abs(item.datatype)])
				subtypes[abs(item.datatype)]=item.subtype;
			if (item.machine != SFSMACHINE) sfsconvi(&item);
#if SFS_SWAP_HEADER
			/* always swap out of sun4 format */
			sun4unswap((int32 *)&item);
#endif
			if (write(out,&item,sizeof(struct item_header)) != sizeof(struct item_header)) {
				sfsclose(out);
				sfsclose(fid);
				upd_files();
				return(0);
			}
			if (item.machine != SFSMACHINE) sfsconvi(&item);
			lseek(fid,sfsdata[fid]->datastart,0);
			if (!upd_copy(item.length,fid,out)) {
				sfsclose(fid);
				sfsclose(out);
				upd_files();
				return(0);
			}
		}
		curcount++;
	}
	sfsclose(fid);
	for (i=0;i<updcount;i++) {
		sfsdata[update[i].fid]->item.subtype = ++subtypes[sfsdata[update[i].fid]->item.datatype];
#if SFS_SWAP_HEADER
		/* always swap out of sun4 format */
		sun4unswap((int32 *)&sfsdata[update[i].fid]->item);
#endif
		if (write(out,&sfsdata[update[i].fid]->item,sizeof(struct item_header)) != sizeof(struct item_header)) {
			sfsclose(out);
			upd_files();
			return(0);
		}
		if (!upd_copy(sfsdata[update[i].fid]->item.length,update[i].fid,out)) {
			sfsclose(out);
			upd_files();
			return(0);
		}
	}
	close(out);
	if (!upd_backup(sfsdata[out]->ofilename,dataname)) {
		upd_files();
		return(0);
	}
	sfsclose(out);
	upd_files();
	return(1);
}

/* check existence of itemno string in history */
static int upd_exist(s,t)
char	*s,*t;
{
	register int	i,j,flag;
	int	ls,lt;
	ls=strlen(s);
	lt=strcspn(t,";=")-ls;
	for (i=1;i<=lt;i++) {
		if (((t[i-1]=='(') || (t[i-1]==',')) && (s[0]==t[i])) {
			flag=1;
			for (j=1;j<ls;j++) if (s[j]!=t[i+j]) flag=0;
			if ((t[i+j]!=')') && (t[i+j]!=';') && (t[i+j]!=',')) flag=0;
			if (flag) return(1);
		}
	}
	return(0);
}

static int upd_files()
{
	int	i;
	for (i=0;i<updcount;i++) {
		close(update[i].fid);
		unlink(sfsdata[update[i].fid]->ofilename);
		free(sfsdata[update[i].fid]);
		sfsdata[update[i].fid]=NULL;
	}
	updcount=0;
	return(0);
}

#define COPYBUFSIZE 16384
#define MIN(x,y) (((x)<(y))?(x):(y))

static int upd_copy(len,ip,op)
int	len;
int	ip,op;
{
	char	buf[COPYBUFSIZE];
	int	count=0;

	while (len > 0) {
		count = read(ip,buf,MIN(COPYBUFSIZE,len));
		if (count==0) return(0);
		if (write(op,buf,count) != count) return(0);
		len -= count;
	}
	return(1);
}

extern int errno;

int upd_backup(src,dst)
char	*src;		/* source filename */
char	*dst;		/* destination filename */
{
	int 	i,err;
	char bak[SFSMAXFILENAME];
	char	*p,*e;

	/* create filename with ".bak" extension */
	strcpy(bak,dst);
	e = &bak[strlen(bak)-1];
	p = e;
#ifdef DOS
	while ((p > bak) && (*p != '/') && (*p != '\\') &&
		(*p != ':') && (*p != '.')) p--;
	if (*p=='.')
		strcpy(p,".bak");
	else
		strcat(bak,".bak");
#else
	while ((p > bak) && (*p != '/')) p--;
	if ((e-p) >= 12) *(p+12)='\0';
	strcat(bak,".bak");
	*(p+14)='\0';
#endif

	/* rename files */
	if (strcmp(dst,bak) != 0) {
		err = unlink(bak);
		if ((err = LINK(dst,bak)) == 0) {
			/* saved old destination file */
#ifdef DOS
			if (((err = unlink(dst)) == 0) || (err=ENOENT)) {
#else
			if ((err = unlink(dst)) == 0) {
#endif
				/* deleted original destination file */
				if ((err = LINK(src,dst)) == 0)
					i = unlink(src);
				else if ((err = upd_cpfiles(src,dst)) == 0)
					i = unlink(src);
				else
					error("link/copy('%s','%s') returns error %d\n",src,dst,errno);
			}
		}
		else if (errno==ENOENT) {
			/* original destination does not exist */
			if ((err = LINK(src,dst)) == 0)
				i = unlink(src);
			else if ((err = upd_cpfiles(src,dst)) == 0)
				i = unlink(src);
			else
				error("link/copy('%s','%s') returns error %d\n",src,dst,errno);
		}
		else
			error("link('%s','%s') returns error %d\n",dst,bak,errno);
	}
	else
		err = -1;

	/* report error */
	if (err != 0) {
/*		fprintf(stderr,"DOS returns error %d\n",errno); */
		err = unlink(src);
		return(0);
	}

	/* normal return */
	return(1);
}

/* copy files rather than link */
int upd_cpfiles(src,dst)
char	*src,*dst;
{
	int	ip,op;
	char	buf[COPYBUFSIZE];
	int	n;

#ifdef DOS
	if ((ip = open(src,O_RDONLY | O_BINARY)) < 0) return(-1);
	if ((op = open(dst,O_WRONLY | O_CREAT | O_BINARY, 0664)) < 0) return(-1);
#else
	if ((ip = open(src,O_RDONLY)) < 0) return(-1);
	if ((op = open(dst,O_WRONLY | O_CREAT, 0664)) < 0) return(-1);
#endif

	while ((n = read(ip,buf,sizeof buf)) > 0)
		if (write(op,buf,n) < 0) return(-1);

	close(ip);
	close(op);
	return(0);
}

#ifdef IAG
main()
{
	char	filename[80],spec[80];
	struct item_header item,newitem;
	char	*buff,*ty;
	int	fid,ofid,it,i;

	printf("Enter filename : ");
	fflush(stdout);
	scanf("%s",filename);
	if ((fid=sfsopen(filename,"r",NULL)) < 0) 
		error("cannot open %s",filename);

	printf("Enter item spec : ");
	fflush(stdout);
	scanf("%s",spec);
	if (itspec(spec,&it,&ty)!=0)
		error("bad item spec: %s",spec);

	if (!sfsitem(fid,it,ty,&item))
		error("cannot find item %s",spec);

	if ((buff=sfsbuffer(&item,item.numframes))==NULL)
		error("could not create memory buffer",NULL);

	if (sfsread(fid,0,item.numframes,buff) != item.numframes)
		error("could not read data set",NULL);

	sfsheader(&newitem,item.datatype,item.floating,
			item.datasize,item.framesize,
			item.frameduration,item.offset,
			item.windowsize,item.overlap,
			item.lxsync);
	sprintf(newitem.history,"sfsupdate(%d.%02d)",
		item.datatype,item.subtype);
	strcpy(newitem.params,"");

	if ((ofid=sfschannel(filename,&newitem)) < 0)
		error("could not open output channel",NULL);

	if (sfswrite(ofid,item.numframes,buff) != item.numframes)
		error("write error on output",NULL);

	sfsclose(fid);
	if (!sfsupdate(filename))
		error("update error on %s",filename);

	printf("added copy of selected item in %s\n",filename);
	exit(0);
}
#endif
